import { Injectable } from '@nestjs/common';
import { CreateTransactionSplitDto } from './dto/create-transaction_split.dto';
import { UpdateTransactionSplitDto } from './dto/update-transaction_split.dto';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';
import { DataSource } from 'typeorm';
import { TransactionSplit } from './entities/transaction_split.entity';

@Injectable()
export class TransactionSplitService {
  constructor(
    private readonly connection: DataSource,
    @InjectModel('TransactionSplit')
    private readonly ServiceModel: Model<TransactionSplit>,
  ) {}

  async create(createTransactionSplitDto: TransactionSplit) {
    console.log(createTransactionSplitDto, 'createTransactionSplitDto');
    createTransactionSplitDto.organisation_share =
      createTransactionSplitDto.organisation_share / 100;

    createTransactionSplitDto.hospital_share =
      createTransactionSplitDto.hospital_share / 100;

    createTransactionSplitDto.overallpaid =
      createTransactionSplitDto.overallpaid / 100;

    createTransactionSplitDto.razorpay_share =
      createTransactionSplitDto.razorpay_share / 100;

    const response = new this.ServiceModel({
      hospital_id: createTransactionSplitDto.hospital_id,
      patient_aayush_id: createTransactionSplitDto.patient_aayush_id,
      admin_transaction_id: createTransactionSplitDto.admin_transaction_id,
      hos_transaction_id: createTransactionSplitDto.hos_transaction_id,
      hospital_share: createTransactionSplitDto.hospital_share,
      organisation_share: createTransactionSplitDto.organisation_share,
      overallpaid: createTransactionSplitDto.overallpaid,
      razorpay_share: createTransactionSplitDto.razorpay_share,
      created_at: new Date(),
    });
    let result = await response.save();
    return result;
  }

  // findAll() {
  //   return `This action returns all transactionSplit`;
  // }

  // findOne(id: number) {
  //   return `This action returns a #${id} transactionSplit`;
  // }

  // update(id: number, updateTransactionSplitDto: UpdateTransactionSplitDto) {
  //   return `This action updates a #${id} transactionSplit`;
  // }

  // remove(id: number) {
  //   return `This action removes a #${id} transactionSplit`;
  // }
}
