import { Module } from '@nestjs/common';
import { TransactionSplitService } from './transaction_split.service';
import { TransactionSplitController } from './transaction_split.controller';
import { MongooseModule } from '@nestjs/mongoose';
import {
  TransactionSplit,
  TransactionSplitSchema,
} from './entities/transaction_split.entity';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: TransactionSplit.name, schema: TransactionSplitSchema },
    ]),
  ],
  controllers: [TransactionSplitController],
  providers: [TransactionSplitService],
})
export class TransactionSplitModule {}
