import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { TransactionSplitService } from './transaction_split.service';
import { CreateTransactionSplitDto } from './dto/create-transaction_split.dto';
import { UpdateTransactionSplitDto } from './dto/update-transaction_split.dto';
import { TransactionSplit } from './entities/transaction_split.entity';

@Controller('transaction-split')
export class TransactionSplitController {
  constructor(
    private readonly transactionSplitService: TransactionSplitService,
  ) {}

  @Post()
  create(@Body() createTransactionSplitDto: TransactionSplit) {
    console.log(createTransactionSplitDto, 'create');

    return this.transactionSplitService.create(createTransactionSplitDto);
  }

  // @Get()
  // findAll() {
  //   return this.transactionSplitService.findAll();
  // }

  // @Get(':id')
  // findOne(@Param('id') id: string) {
  //   return this.transactionSplitService.findOne(+id);
  // }

  // @Patch(':id')
  // update(@Param('id') id: string, @Body() updateTransactionSplitDto: UpdateTransactionSplitDto) {
  //   return this.transactionSplitService.update(+id, updateTransactionSplitDto);
  // }

  // @Delete(':id')
  // remove(@Param('id') id: string) {
  //   return this.transactionSplitService.remove(+id);
  // }
}
