import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document } from 'mongoose';

export type TransactionSplitDocument = TransactionSplit & Document;

@Schema({
  collection: 'transaction_split',
  timestamps: { createdAt: 'created_at' },
})
export class TransactionSplit {
  @Prop({ required: true })
  hospital_id: number;

  @Prop({ required: true })
  patient_aayush_id: string;

  @Prop({ required: true })
  admin_transaction_id: number;

  @Prop({ required: true })
  hos_transaction_id: number;

  @Prop({ required: true })
  hospital_share: number;

  @Prop({ required: true })
  organisation_share: number;

  @Prop({ required: true })
  razorpay_share: number;

  @Prop({ required: true })
  overallpaid: number;

  @Prop({ required: false })
  created_at: Date;
}

export const TransactionSplitSchema =
  SchemaFactory.createForClass(TransactionSplit);
