import { Controller, Get, Post, Body, Patch, Param, Delete } from '@nestjs/common';
import { PhrNewBillingService } from './phr-new-billing.service';
import { CreatePhrNewBillingDto } from './dto/create-phr-new-billing.dto';
import { UpdatePhrNewBillingDto } from './dto/update-phr-new-billing.dto';

@Controller('phr-new-billing')
export class PhrNewBillingController {
  constructor(private readonly phrNewBillingService: PhrNewBillingService) {}

  @Post()
  create(@Body() createPhrNewBillingDto: CreatePhrNewBillingDto) {
    return this.phrNewBillingService.create(createPhrNewBillingDto);
  }

  @Get()
  findAll() {
    return this.phrNewBillingService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.phrNewBillingService.findOne(+id);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updatePhrNewBillingDto: UpdatePhrNewBillingDto) {
    return this.phrNewBillingService.update(+id, updatePhrNewBillingDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.phrNewBillingService.remove(+id);
  }
}
