import { Module } from '@nestjs/common';
import { PhrAppointmentService } from './phr-appointment.service';
import { PhrAppointmentController } from './phr-appointment.controller';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
import { TransactionSplitService } from 'src/transaction_split/transaction_split.service';
import { MongooseModule } from '@nestjs/mongoose';
import {
  TransactionSplit,
  TransactionSplitSchema,
} from 'src/transaction_split/entities/transaction_split.entity';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: TransactionSplit.name, schema: TransactionSplitSchema },
    ]),
  ],
  controllers: [PhrAppointmentController],
  providers: [PhrAppointmentService, FaceAuthService, TransactionSplitService],
})
export class PhrAppointmentModule {}
