import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  Query,
  UseGuards,
} from '@nestjs/common';
import { OpdVoiceDateService } from './opd_voice_date.service';
import { OpdVoiceDate } from './entities/opd_voice_date.entity';
import { AuthGuard } from 'src/auth/auth.guard';

@Controller('opd-voice-date')
export class OpdVoiceDateController {
  constructor(private readonly opdVoiceDateService: OpdVoiceDateService) {}

  @UseGuards(AuthGuard)
  @Post('/admin')
  async create(@Body() createOpdVoiceDateDto: OpdVoiceDate) {
    const res = await this.opdVoiceDateService.create(createOpdVoiceDateDto);
    return {
      responseCode: 200,
      responseMessage: 'Record created successfully',
      data: res,
    };
  }

  @UseGuards(AuthGuard)
  @Get('/admin/:id')
  async findOne(
    @Param('id') id: number,
    @Query('hospital_id') hospital_id: number,
  ) {
    const res = await this.opdVoiceDateService.findOne(id, hospital_id);
    return {
      responseCode: 200,
      responseMessage: 'Record found successfully',
      data: res,
    };
  }

  @UseGuards(AuthGuard)
  @Patch('/admin/:id')
  async update(
    @Param('id') id: string,
    @Body() updateOpdVoiceDateDto: OpdVoiceDate,
  ) {
    const res = await this.opdVoiceDateService.update(
      id,
      updateOpdVoiceDateDto,
    );
    return {
      responseCode: 200,
      responseMessage: 'Record updated successfully',
      data: {
        voiceId: id,
      },
    };
  }

  @UseGuards(AuthGuard)
  @Post('/hospital')
  async hoscreate(@Body() createOpdVoiceDateDto: OpdVoiceDate) {
    const res = await this.opdVoiceDateService.hoscreate(createOpdVoiceDateDto);
    return {
      responseCode: 200,
      responseMessage: 'Record created successfully',
      data: {
        voiceId: res,
      },
    };
  }

  // @UseGuards(AuthGuard)
  // @Get('/hospital/:id')
  // async hosFindOne(
  //   @Param('id') id: number,
  //   @Query('hospital_id') hospital_id: number,
  // ) {
  //   const { doctor_name, appointment_date, appointment_time, data } =
  //     await this.opdVoiceDateService.hosFindOne(id, hospital_id);

  //   return {
  //     responseCode: 200,
  //     responseMessage: 'Record found successfully',
  //     doctor_name,
  //     appointment_date,
  //     appointment_time,
  //     data,
  //   };
  // }

  @UseGuards(AuthGuard)
  @Get('/hospital/:id')
  async hosFindOne(
    @Param('id') id: number,
    @Query('hospital_id') hospital_id: number,
  ) {
    const res = await this.opdVoiceDateService.hosFindOne(id, hospital_id);

    return {
      responseCode: 200,
      responseMessage: 'Record found successfully',
      details: res.details[0],
      data: res.voice_data,
    };
  }

  @UseGuards(AuthGuard)
  @Patch('/hospital/:id')
  async hosupdate(
    @Param('id') id: string,
    @Body() updateOpdVoiceDateDto: OpdVoiceDate,
  ) {
    const res = await this.opdVoiceDateService.hosupdate(
      id,
      updateOpdVoiceDateDto,
    );
    return {
      responseCode: 200,
      responseMessage: 'Record updated successfully',
      data: {
        voiceId: id,
      },
    };
  }
}
