import { Injectable } from '@nestjs/common';
import { CreateOpHubBundleGenerationDto } from './dto/create-op-hub-bundle-generation.dto';
import { UpdateOpHubBundleGenerationDto } from './dto/update-op-hub-bundle-generation.dto';
import { forwardRef, Inject } from '@nestjs/common';
import { OpHubPreviewDocService } from 'src/op-hub-preview-doc/op-hub-preview-doc.service';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { InjectDataSource } from '@nestjs/typeorm';
import axios from 'axios';
import { awsConfig } from 'src/aws.config';
import { DataSource } from 'typeorm';
import { v4 as uuidv4 } from 'uuid';
import { S3, GetObjectCommand } from '@aws-sdk/client-s3';
@Injectable()
export class OpHubBundleGenerationService {
  constructor(
    private readonly dynamicConnection: DataSource,
    @InjectDataSource('AdminConnection')
    private readonly connection: DataSource,
  ) {}

  async create(
    followupDetails: any,
    other_observations: any,
    Lifestyle: any,
    women_health: any,
    generalAssment: any,
    physicalActivity: any,
    vitalDetails: any,
    body_measurement: any,
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        messege: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );
    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );
    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );
    console.log(getPatDOB, 'getPatDOB', getPatientID.patient_id);

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = await getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
        coalesce(patients.patient_name,"-") patientName,
        coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
        date(patients.dob) bundleDate,
        coalesce(patients.age,"-") age,
        coalesce(patients.mobileno,"-") mobileno,
        coalesce(patients.email,"-") email,
        coalesce(patients.gender,"-") gender,
        coalesce(patients.abha_address,"-") abha_address,
        coalesce(patients.address,"-") address,
        coalesce(blood_bank_products.name,"-") patient_blood_group 
      from patients 
      left join blood_bank_products 
        on patients.blood_bank_product_id = blood_bank_products.id 
      where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
      from staff where id = ?`,
      [getDocId.cons_doctor],
    );
    console.log(doctorDetails, 'doctorDetails', getDocId.cons_doctor);

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '736373009',
                  display: 'Wellness record',
                },
              ],
              text: 'Wellness Record',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: [
              {
                reference: `urn:uuid:${PatientID}`,
                display: patientDetails.patientName,
              },
            ],
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Wellness Record',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: 'Plenome',
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: [
              {
                system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
                code: 'AMB',
                display: 'OPD Visit',
              },
            ],
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    if (followupDetails) {
      let FollowupID = uuidv4();
      wellnessBundle.entry[0].resource.section.push({
        title: 'Follow up',
        entry: [
          {
            reference: `urn:uuid:${FollowupID}`,
            display: 'Follow-up Instruction',
          },
        ],
      });

      wellnessBundle.entry.push({
        fullUrl: `urn:uuid:${FollowupID}`,
        resource: {
          resourceType: 'CarePlan',
          id: FollowupID,
          status: 'active',
          intent: 'plan',
          title: 'Follow-up Plan',
          description: `Patient needs to return on follow-up date ${followupDetails.followup_date}`,
          subject: { reference: `urn:uuid:${PatientID}` },
        },
      });
    }

    if (other_observations && other_observations.length > 0) {
      const refs = [];
      const entries = [];

      other_observations.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Other Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            code: { text: obs.display || 'Other Obervations' },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Other Observations',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (Lifestyle && Lifestyle.length > 0) {
      const refs = [];
      const entries = [];

      Lifestyle.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'lifestyle',
                    display: 'Lifestyle',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Lifestyle',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (women_health && women_health.length > 0) {
      const refs = [];
      const entries = [];

      women_health.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            code: { text: obs.display },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Women Health',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (generalAssment && generalAssment.length > 0) {
      const refs = [];
      const entries = [];

      generalAssment.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'survey',
                    display: 'Survey',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display },
            valueString: obs.value,
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'General Assessment',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (physicalActivity && physicalActivity.length > 0) {
      const refs = [];
      const entries = [];

      physicalActivity.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'activity',
                    display: 'Activity',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display },
            valueString: obs.value,
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Physical Activity',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (vitalDetails && vitalDetails.length > 0) {
      const refs = [];
      const entries = [];

      vitalDetails.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'vital-signs',
                    display: 'Vital Signs',
                  },
                ],
                text: 'Vital Signs',
              },
            ],
            code: {
              text: obs.display,
            },
            subject: { reference: `urn:uuid:${PatientID}` },
            effectiveDateTime: CurrDate,
            performer: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: 'Practitioner',
              },
            ],
            valueQuantity: {
              value: Number(obs.value),
              unit: obs.unit || '',
            },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Vital Signs',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (body_measurement && body_measurement.length > 0) {
      const refs = [];
      const entries = [];

      body_measurement.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'exam',
                    display: 'Exam',
                  },
                ],
              },
            ],
            code: {
              text: obs.display,
            },
            subject: { reference: `urn:uuid:${PatientID}` },
            effectiveDateTime: CurrDate,
            performer: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: 'Practitioner',
              },
            ],
            valueQuantity: {
              value: Number(obs.value),
              unit: obs.unit || '',
            },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Body Measurement',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Wellness Record Linked',
          careContexts: [
            {
              display: 'Wellness document' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'WellnessRecord',
          count: 1,
        },
      ],
    };

    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  // async createDischargeSummary(
  //   followupDetails: any,
  //   clinicalPresentation: any,
  //   investigationsPerformed: any,
  //   treatment_given: any,
  //   condition_at_discharge: any,
  //   discharge_advice: any,
  //   hospital_id: any,
  //   opd_id: any,
  //   abhaAddress: string
  // ) {
  //   if (!hospital_id) {
  //     return {
  //       status: 'failed',
  //       messege: 'enter hospital_id to post clinical notes',
  //     };
  //   }

  //   const [getPatientID] = await this.dynamicConnection.query(
  //     `select patient_id from opd_details where id = ?`,
  //     [opd_id],
  //   );
  //   const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
  //     `select * from patient_abha_address where abhaAddress = ?`,
  //     [abhaAddress],
  //   );
  //   const [getPatDOB] = await this.dynamicConnection.query(
  //     `select * from patients where id = ?`,
  //     [getPatientID.patient_id],
  //   );
  //   console.log(getPatDOB, "getPatDOB", getPatientID.patient_id);

  //   let yob;
  //   if (getPatDOB.dob) {
  //     const [getYob] = await this.dynamicConnection.query(
  //       `SELECT YEAR(dob) AS year FROM patients where id = ?`,
  //       [getPatientID.patient_id],
  //     );
  //     yob = await getYob.year;
  //   }

  //   const [patientDetails] = await this.dynamicConnection.query(
  //     `select patients.id,
  //       coalesce(patients.patient_name,"-") patientName,
  //       coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
  //       date(patients.dob) bundleDate,
  //       coalesce(patients.age,"-") age,
  //       coalesce(patients.mobileno,"-") mobileno,
  //       coalesce(patients.email,"-") email,
  //       coalesce(patients.gender,"-") gender,
  //       coalesce(patients.abha_address,"-") abha_address,
  //       coalesce(patients.address,"-") address,
  //       coalesce(blood_bank_products.name,"-") patient_blood_group
  //     from patients
  //     left join blood_bank_products
  //       on patients.blood_bank_product_id = blood_bank_products.id
  //     where patients.id = ?`,
  //     [getPatientID.patient_id],
  //   );

  //   const [getDocId] = await this.dynamicConnection.query(
  //     `select cons_doctor from visit_details where opd_details_id = ?`,
  //     [opd_id],
  //   );

  //   const [doctorDetails] = await this.dynamicConnection.query(
  //     `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender
  //     from staff where id = ?`,
  //     [getDocId.cons_doctor],
  //   );
  //   const bundleDate = new Date(patientDetails.bundleDate);
  //   const options = {
  //     year: 'numeric' as const,
  //     month: '2-digit' as const,
  //     day: '2-digit' as const,
  //     hour: '2-digit' as const,
  //     minute: '2-digit' as const,
  //     second: '2-digit' as const,
  //     hourCycle: 'h23' as const,
  //     timeZone: 'Asia/Kolkata',
  //   };

  //   const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
  //     bundleDate,
  //   );
  //   const [date, time] = new_bundle_Date.split(', ');
  //   const isoDate = `${date}T${time}`;
  //   const finaldob = isoDate.split('T')[0];
  //   patientDetails.bundleDate = finaldob;

  //   const [getHosDetails] = await this.connection.query(
  //     `select * from hospitals where plenome_id = ?`,
  //     [hospital_id],
  //   );
  //   const [getHosHipId] = await this.connection.query(
  //     `select hip_id from hospitals where plenome_id = ?`,
  //     [hospital_id],
  //   );
  //   let CurrDate = new Date().toISOString();
  //   let CompositionID = uuidv4();
  //   let PractitionerID = uuidv4();
  //   let PatientID = uuidv4();
  //   let OrgtID = uuidv4();
  //   let EncounterID = uuidv4();

  //   let wellnessBundle: any = {
  //     resourceType: 'Bundle',
  //     id: uuidv4(),
  //     meta: {
  //       versionId: '1',
  //       lastUpdated: CurrDate,
  //       profile: [
  //         'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
  //       ],
  //       security: [
  //         {
  //           system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
  //           code: 'V',
  //           display: 'very restricted',
  //         },
  //       ],
  //     },
  //     identifier: {
  //       system: 'http://hip.in',
  //       value: uuidv4(),
  //     },
  //     type: 'document',
  //     timestamp: CurrDate,
  //     entry: [
  //       {
  //         fullUrl: `urn:uuid:${CompositionID}`,
  //         resource: {
  //           resourceType: 'Composition',
  //           id: CompositionID,
  //           language: 'en-IN',
  //           identifier: [{
  //             system: 'https://ndhm.in/phr',
  //             value: uuidv4(),
  //           }],
  //           status: 'final',
  //           type: {
  //             coding: [
  //               {
  //                 system: 'http://snomed.info/sct',
  //                 code: '736373009',
  //                 display: 'discharge summary Record',
  //               },
  //             ],
  //             text: 'discharge summary Record',
  //           },
  //           encounter: {
  //             reference: `urn:uuid:${EncounterID}`,
  //           },
  //           subject: [{
  //             reference: `urn:uuid:${PatientID}`,
  //             display: patientDetails.patientName,
  //           }],
  //           date: CurrDate,
  //           author: [
  //             {
  //               reference: `urn:uuid:${PractitionerID}`,
  //               display: `Dr. ${doctorDetails.doctorName}`,
  //             },
  //           ],
  //           title: 'Wellness Record',
  //           custodian: {
  //             reference: `urn:uuid:${OrgtID}`,
  //             display: 'Plenome',
  //           },
  //           section: [],
  //         },
  //       },
  //       {
  //         fullUrl: `urn:uuid:${PractitionerID}`,
  //         resource: {
  //           resourceType: 'Practitioner',
  //           id: PractitionerID,
  //           identifier: [
  //             {
  //               type: {
  //                 coding: [
  //                   {
  //                     system:
  //                       'http://terminology.hl7.org/CodeSystem/v2-0203',
  //                     code: 'MD',
  //                     display: 'Medical License number',
  //                   },
  //                 ],
  //               },
  //               system: 'https://doctor.ndhm.gov.in',
  //               value: doctorDetails.employee_id || '21-1521-3828-3227',
  //             },
  //           ],
  //           name: [
  //             {
  //               text: `Dr. ${doctorDetails.doctorName}`,
  //             },
  //           ],
  //         },
  //       },
  //       {
  //         fullUrl: `urn:uuid:${PatientID}`,
  //         resource: {
  //           resourceType: 'Patient',
  //           id: PatientID,
  //           identifier: [
  //             {
  //               type: {
  //                 coding: [
  //                   {
  //                     system:
  //                       'http://terminology.hl7.org/CodeSystem/v2-0203',
  //                     code: 'MR',
  //                     display: 'Medical record number',
  //                   },
  //                 ],
  //               },
  //               system: 'https://healthid.ndhm.gov.in',
  //               value: patientDetails.abha_address || uuidv4(),
  //             },
  //           ],
  //           name: [
  //             {
  //               text: patientDetails.patientName,
  //             },
  //           ],
  //           telecom: [
  //             {
  //               system: 'phone',
  //               value: String(patientDetails.mobileno),
  //               use: 'home',
  //             },
  //           ],
  //           gender: patientDetails.gender?.toLowerCase(),
  //           birthDate: patientDetails.bundleDate,
  //         },
  //       },
  //       {
  //         fullUrl: `urn:uuid:${EncounterID}`,
  //         resource: {
  //           resourceType: 'Encounter',
  //           id: EncounterID,
  //           status: 'finished',
  //           class: [{
  //             system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
  //             code: 'AMB',
  //             display: 'OPD Visit',
  //           }],
  //           subject: {
  //             reference: `urn:uuid:${PatientID}`,
  //           },
  //           period: {
  //             start: CurrDate,
  //           },
  //         },
  //       },
  //       {
  //         fullUrl: `urn:uuid:${OrgtID}`,
  //         resource: {
  //           resourceType: 'Organization',
  //           id: OrgtID,
  //           identifier: [
  //             {
  //               type: {
  //                 coding: [
  //                   {
  //                     system:
  //                       'http://terminology.hl7.org/CodeSystem/v2-0203',
  //                     code: 'PRN',
  //                     display: 'Provider number',
  //                   },
  //                 ],
  //               },
  //               system: 'https://facility.ndhm.gov.in',
  //               value: String(getHosDetails.plenome_id) || '4567823',
  //             },
  //           ],
  //           name: getHosDetails.hospital_name,
  //           telecom: [
  //             {
  //               system: 'phone',
  //               value: getHosDetails.contact_no,
  //               use: 'work',
  //             },
  //             {
  //               system: 'email',
  //               value: getHosDetails.email,
  //               use: 'work',
  //             },
  //           ],
  //         },
  //       },
  //     ],
  //   };

  //   if (followupDetails) {
  //     let FollowupID = uuidv4();
  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'Follow up',
  //       entry: [
  //         {
  //           reference: `urn:uuid:${FollowupID}`,
  //           display: 'Follow-up Instruction',
  //         },
  //       ],
  //     });

  //     wellnessBundle.entry.push({
  //       fullUrl: `urn:uuid:${FollowupID}`,
  //       resource: {
  //         resourceType: 'CarePlan',
  //         id: FollowupID,
  //         status: 'active',
  //         intent: 'plan',
  //         title: 'Follow-up Plan',
  //         description: `Patient needs to return on follow-up date ${followupDetails.followup_date}`,
  //         subject: { reference: `urn:uuid:${PatientID}` },
  //       },
  //     });
  //   }

  //   if (clinicalPresentation && clinicalPresentation.length > 0) {
  //     const refs = [];
  //     const entries = [];

  //     other_observations.forEach((obs) => {
  //       const obsId = uuidv4();
  //       refs.push({
  //         reference: `urn:uuid:${obsId}`,
  //         display: obs.display || 'Other Observation',
  //       });

  //       entries.push({
  //         fullUrl: `urn:uuid:${obsId}`,
  //         resource: {
  //           resourceType: 'Observation',
  //           id: obsId,
  //           status: 'final',
  //           code: { text: obs.display || 'Other Obervations' },
  //           valueString: obs.value || '',
  //           subject: { reference: `urn:uuid:${PatientID}` },
  //         },
  //       });
  //     });

  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'Other Observations',
  //       entry: refs,
  //     });
  //     wellnessBundle.entry.push(...entries);
  //   }

  //   if (investigationsPerformed && investigationsPerformed.length > 0) {
  //     const refs = [];
  //     const entries = [];

  //     Lifestyle.forEach((obs) => {
  //       const obsId = uuidv4();
  //       refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

  //       entries.push({
  //         fullUrl: `urn:uuid:${obsId}`,
  //         resource: {
  //           resourceType: 'Observation',
  //           id: obsId,
  //           category: [
  //             {
  //               coding: [
  //                 {
  //                   system:
  //                     'http://terminology.hl7.org/CodeSystem/observation-category',
  //                   code: 'lifestyle',
  //                   display: 'Lifestyle',
  //                 },
  //               ],
  //             },
  //           ],
  //           status: 'final',
  //           code: { text: obs.display },
  //           valueString: obs.value || '',
  //           subject: { reference: `urn:uuid:${PatientID}` },
  //         },
  //       });
  //     });

  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'Lifestyle',
  //       entry: refs,
  //     });
  //     wellnessBundle.entry.push(...entries);
  //   }

  //   if (treatment_given && treatment_given.length > 0) {
  //     const refs = [];
  //     const entries = [];

  //     women_health.forEach((obs) => {
  //       const obsId = uuidv4();
  //       refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

  //       entries.push({
  //         fullUrl: `urn:uuid:${obsId}`,
  //         resource: {
  //           resourceType: 'Observation',
  //           id: obsId,
  //           status: 'final',
  //           code: { text: obs.display },
  //           valueString: obs.value || '',
  //           subject: { reference: `urn:uuid:${PatientID}` },
  //         },
  //       });
  //     });

  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'Women Health',
  //       entry: refs,
  //     });
  //     wellnessBundle.entry.push(...entries);
  //   }

  //   if (condition_at_discharge && condition_at_discharge.length > 0) {
  //     const refs = [];
  //     const entries = [];

  //     generalAssment.forEach((obs) => {
  //       const obsId = uuidv4();
  //       refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

  //       entries.push({
  //         fullUrl: `urn:uuid:${obsId}`,
  //         resource: {
  //           resourceType: 'Observation',
  //           id: obsId,
  //           category: [
  //             {
  //               coding: [
  //                 {
  //                   system:
  //                     'http://terminology.hl7.org/CodeSystem/observation-category',
  //                   code: 'survey',
  //                   display: 'Survey',
  //                 },
  //               ],
  //             },
  //           ],
  //           status: 'final',
  //           code: { text: obs.display },
  //           valueString: obs.value,
  //           subject: { reference: `urn:uuid:${PatientID}` },
  //         },
  //       });
  //     });

  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'General Assessment',
  //       entry: refs,
  //     });
  //     wellnessBundle.entry.push(...entries);
  //   }

  //   if (discharge_advice && discharge_advice.length > 0) {
  //     const refs = [];
  //     const entries = [];

  //     physicalActivity.forEach((obs) => {
  //       const obsId = uuidv4();
  //       refs.push({ reference: `urn:uuid:${obsId}`, display: obs.display });

  //       entries.push({
  //         fullUrl: `urn:uuid:${obsId}`,
  //         resource: {
  //           resourceType: 'Observation',
  //           id: obsId,
  //           category: [
  //             {
  //               coding: [
  //                 {
  //                   system:
  //                     'http://terminology.hl7.org/CodeSystem/observation-category',
  //                   code: 'activity',
  //                   display: 'Activity',
  //                 },
  //               ],
  //             },
  //           ],
  //           status: 'final',
  //           code: { text: obs.display },
  //           valueString: obs.value,
  //           subject: { reference: `urn:uuid:${PatientID}` },
  //         },
  //       });
  //     });

  //     wellnessBundle.entry[0].resource.section.push({
  //       title: 'Physical Activity',
  //       entry: refs,
  //     });
  //     wellnessBundle.entry.push(...entries);
  //   }

  //   const uploadWellnessBody = {
  //     value: wellnessBundle,
  //   };

  //   const response1 = await axios.post(
  //     'https://abha-api.plenome.com/file_upload',
  //     uploadWellnessBody,
  //   );
  //   const currentDate = new Date();
  //   const formattedDate = currentDate.toISOString().split('T')[0];

  //   const carecontext_reqbody = {
  //     // "abhaNumber": "91287816066859",    //optional
  //     abhaAddress: abhaAddress,
  //     patient_ref_no: await getPatDOB.aayush_unique_id,
  //     patient: [
  //       {
  //         display: 'Wellness Record Linked',
  //         careContexts: [
  //           {
  //             display: 'Wellness document' + formattedDate,
  //             doc_key: response1.data.data,
  //           },
  //         ],

  //         hiType: 'WellnessRecord',
  //         count: 1,
  //       },
  //     ],
  //   };

  //   if (
  //     abhaAddress &&
  //     abhaAddress.trim() != '' &&
  //     abhaAddress.toLocaleLowerCase() != 'null'
  //   ) {
  //     if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
  //       const PatientDetails = await patientDetails;

  //       if (
  //         checkPatientAbhaAddress.link_token_updated_date &&
  //         checkPatientAbhaAddress.linkToken
  //       ) {
  //         const givenDate = new Date(
  //           checkPatientAbhaAddress.link_token_updated_date,
  //         ); // Replace with your date
  //         const currentDate = new Date();

  //         // Set time to 00:00:00 for both dates to avoid time issues
  //         currentDate.setHours(0, 0, 0, 0);
  //         givenDate.setHours(0, 0, 0, 0);

  //         // Calculate the difference in months
  //         const monthDifference =
  //           (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
  //           currentDate.getMonth() -
  //           givenDate.getMonth();

  //         if (monthDifference > 5) {
  //           const getPatnameBody = {
  //             abhaAddress: abhaAddress,
  //           };

  //           const getname = await axios.post(
  //             'https://abha-api.plenome.com/m1-abha-address-verification',
  //             getPatnameBody,
  //           );

  //           const PatName = await getname.data.fullName;
  //           let patGender;
  //           if (
  //             PatientDetails.gender.toLocaleLowerCase() == 'male' ||
  //             PatientDetails.gender.toLocaleLowerCase() == 'm'
  //           ) {
  //             patGender = 'M';
  //           } else if (
  //             PatientDetails.gender.toLocaleLowerCase() == 'female' ||
  //             PatientDetails.gender.toLocaleLowerCase() == 'f'
  //           ) {
  //             patGender = 'F';
  //           } else {
  //             patGender = 'O';
  //           }

  //           const getLinkTokenBody = {
  //             name: await PatName,
  //             gender: await patGender,
  //             yearOfBirth: await yob,
  //             abhaAddress: abhaAddress,
  //           };
  //           const headers = {
  //             'X-HIP-ID': await getHosHipId.hip_id,
  //             'Content-Type': 'application/json',
  //           };
  //           console.log('getLinkTokenBody', getLinkTokenBody);

  //           const getLinkToken = await axios.post(
  //             'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
  //             getLinkTokenBody,
  //             { headers },
  //           );

  //           this.updateLinkToken(
  //             hospital_id,
  //             getLinkToken.data[0].response[0].payload.linkToken,
  //             abhaAddress,
  //           );
  //         }
  //       } else {
  //         const getPatnameBody = {
  //           abhaAddress: abhaAddress,
  //         };

  //         const getname = await axios.post(
  //           'https://abha-api.plenome.com/m1-abha-address-verification',
  //           getPatnameBody,
  //         );

  //         const PatName = await getname.data.fullName;
  //         let patGender;
  //         if (
  //           PatientDetails.gender.toLocaleLowerCase() == 'male' ||
  //           PatientDetails.gender.toLocaleLowerCase() == 'm'
  //         ) {
  //           patGender = 'M';
  //         } else if (
  //           PatientDetails.gender.toLocaleLowerCase() == 'female' ||
  //           PatientDetails.gender.toLocaleLowerCase() == 'f'
  //         ) {
  //           patGender = 'F';
  //         } else {
  //           patGender = 'O';
  //         }

  //         const [getHosHipId] = await this.connection.query(
  //           `select hip_id from hospitals where plenome_id = ?`,
  //           [hospital_id],
  //         );

  //         const getLinkTokenBody = {
  //           name: await PatName,
  //           gender: await patGender,
  //           yearOfBirth: await yob,
  //           abhaAddress: abhaAddress,
  //         };

  //         const headers = {
  //           'X-HIP-ID': await getHosHipId.hip_id,
  //           'Content-Type': 'application/json',
  //         };
  //         const getLinkToken = await axios.post(
  //           'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
  //           getLinkTokenBody,
  //           { headers },
  //         );
  //         console.log('asdffffffffdsaasdf');

  //         await this.updateLinkToken(
  //           hospital_id,
  //           getLinkToken.data[0].response[0].payload.linkToken,
  //           abhaAddress,
  //         );
  //       }
  //       const existing_link_token: any = await this.getexistingLinkToken(
  //         hospital_id,
  //         abhaAddress,
  //       );

  //       console.log(
  //         1,
  //         existing_link_token.linkToken,
  //         'existing_link_token.linkToken',
  //       );

  //       if (existing_link_token.linkToken) {
  //         console.log(
  //           existing_link_token.linkToken,
  //           'existing_link_token.linkToken',
  //         );

  //         const cc_headers = {
  //           'X-LINK-TOKEN': await existing_link_token.linkToken,
  //           'X-HIP-ID': await getHosHipId.hip_id,
  //           'Content-Type': 'application/json',
  //         };
  //         await axios.post(
  //           'https://abha-api.plenome.com/link/carecontext',
  //           carecontext_reqbody,
  //           { headers: cc_headers },
  //         );
  //       }
  //     }
  //   } else {
  //     const cc_headers = {
  //       'X-LINK-TOKEN': 'Temp_linktoken',
  //       'X-HIP-ID': await getHosHipId.hip_id,
  //       'Content-Type': 'application/json',
  //     };
  //     console.log(cc_headers, 'cc_headers');
  //     try {
  //       console.log('carecontext_reqbody', carecontext_reqbody);

  //       await axios.post(
  //         'https://abha-api.plenome.com/link/carecontext',
  //         carecontext_reqbody,
  //         { headers: cc_headers },
  //       );
  //     } catch (error) {
  //       console.log(error, 'error1111');
  //     }
  //     //  await axios.post(
  //     //   "https://abha-api.plenome.com/link/carecontext",
  //     //   carecontext_reqbody,
  //     //   { headers: cc_headers }
  //     // );
  //   }
  //   return wellnessBundle;

  // }

  async createDischargeSummary(
    followupDetails: any,
    clinicalPresentation: any[],
    investigationsPerformed: any[],
    treatment_given: any[],
    condition_at_discharge: any[],
    discharge_advice: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '736373009',
                  display: 'Discharge Summary Record',
                },
              ],
              text: 'Discharge Summary Record',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Discharge Summary',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    if (followupDetails) {
      let FollowupID = uuidv4();
      wellnessBundle.entry[0].resource.section.push({
        title: 'Follow up',
        entry: [
          {
            reference: `urn:uuid:${FollowupID}`,
            display: 'Follow-up Instruction',
          },
        ],
      });

      wellnessBundle.entry.push({
        fullUrl: `urn:uuid:${FollowupID}`,
        resource: {
          resourceType: 'CarePlan',
          id: FollowupID,
          status: 'active',
          intent: 'plan',
          title: 'Follow-up Plan',
          description: `Patient needs to return on follow-up date ${followupDetails.followup_date}`,
          subject: { reference: `urn:uuid:${PatientID}` },
        },
      });
    }

    if (clinicalPresentation?.length > 0) {
      const refs = [];
      const entries = [];

      clinicalPresentation.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            code: { text: obs.display || 'note' },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Clinical Presentation',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (investigationsPerformed?.length > 0) {
      const refs = [];
      const entries = [];

      investigationsPerformed.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'exam',
                    display: 'Exam',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display || 'note' },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Investigations Performed',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (treatment_given?.length > 0) {
      const refs = [];
      const entries = [];

      treatment_given.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            status: 'final',
            code: { text: obs.display || 'note' },
            valueString: obs.value || '',
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Treatment Given',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (condition_at_discharge?.length > 0) {
      const refs = [];
      const entries = [];

      condition_at_discharge.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'survey',
                    display: 'Survey',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display || 'note' },
            valueString: obs.value,
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Condition at Discharge',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    if (discharge_advice?.length > 0) {
      const refs = [];
      const entries = [];

      discharge_advice.forEach((obs) => {
        const obsId = uuidv4();
        refs.push({
          reference: `urn:uuid:${obsId}`,
          display: obs.display || 'Observation',
        });

        entries.push({
          fullUrl: `urn:uuid:${obsId}`,
          resource: {
            resourceType: 'Observation',
            id: obsId,
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'activity',
                    display: 'Activity',
                  },
                ],
              },
            ],
            status: 'final',
            code: { text: obs.display || 'note' },
            valueString: obs.value,
            subject: { reference: `urn:uuid:${PatientID}` },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Discharge Advice',
        entry: refs,
      });
      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Discharge Summary Record Linked',
          careContexts: [
            {
              display: 'Discharge Summary Record' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'DischargeSummary',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  async createPrescription(
    prescriptionDetails: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '736373009',
                  display: 'Prescription Record',
                },
              ],
              text: 'Prescription Record',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Prescription',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    if (prescriptionDetails && prescriptionDetails?.length > 0) {
      const refs = [];
      const entries = [];

      prescriptionDetails.forEach((med) => {
        const medId = uuidv4();
        refs.push({ reference: `urn:uuid:${medId}` });

        entries.push({
          fullUrl: `urn:uuid:${medId}`,
          resource: {
            resourceType: 'MedicationRequest',
            id: medId,
            status: 'active',
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/MedicationRequest',
              ],
            },
            intent: 'order',
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails?.patientName,
            },
            authoredOn: CurrDate,
            requester: {
              reference: `urn:uuid:${PractitionerID}`,
              display: doctorDetails?.doctorName,
            },
            medicationCodeableConcept: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '1145423002',
                  display: med.medicineName,
                },
              ],
              text: med.medicineName,
            },

            dosageInstruction: [
              {
                text: med.remarks || '', // free remarks if any
                timing: {
                  repeat: {
                    frequency: med.frequency
                      ? Number(med.frequency)
                      : undefined,
                    period: med.duration ? Number(med.duration) : undefined,
                    periodUnit: med.duration_unit, // assuming duration is in days
                  },
                  code: { text: med.timing }, // Morning/Evening/etc
                },
                doseAndRate: [
                  {
                    doseQuantity: {
                      value: med.dosage ? Number(med.dosage) : undefined,
                      unit: med.unit,
                    },
                  },
                ],
              },
            ],

            dispenseRequest: {
              quantity: {
                value: med.quantity ? Number(med.quantity) : undefined,
                unit: med.medicine_type, // adjust unit if needed
              },
            },
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Medications',
        code: {
          coding: [
            {
              system: 'http://loinc.org',
              code: '10160-0',
              display: 'History of Medication use',
            },
          ],
        },
        entry: refs,
      });

      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Prescription Record Linked',
          careContexts: [
            {
              display: 'Prescription Record' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'Prescription',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  async createImmunization(
    immunizationDetails: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '736373009',
                  display: 'ImmunizationRecord',
                },
              ],
              text: 'ImmunizationRecord',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'ImmunizationRecord',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    if (immunizationDetails && immunizationDetails?.length > 0) {
      const refs = [];
      const entries = [];

      immunizationDetails.forEach((imm) => {
        const immId = uuidv4();
        refs.push({ reference: `urn:uuid:${immId}` });

        entries.push({
          fullUrl: `urn:uuid:${immId}`,
          resource: {
            resourceType: 'Immunization',
            id: immId,
            status: 'completed',
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Immunization',
              ],
            },
            vaccineCode: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  // You can map vaccineName → SNOMED code if you have it
                  display: imm.vaccineName,
                },
              ],
              text: imm.vaccineName,
            },
            patient: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails?.patientName,
            },
            occurrenceDateTime: new Date(imm.dateOfImmunization).toISOString(),
            // date string
            manufacturer: {
              display: imm.manufacturer,
            },
            lotNumber: imm.lotNumber,
            protocolApplied: [
              {
                doseNumberPositiveInt: Number(imm.doseNumber)
                  ? Number(imm.doseNumber)
                  : undefined,
              },
            ],
            performer: [
              {
                actor: {
                  reference: `urn:uuid:${PractitionerID}`,
                  display: doctorDetails?.doctorName,
                },
              },
            ],
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Immunizations',
        code: {
          coding: [
            {
              system: 'http://loinc.org',
              code: '11369-6',
              display: 'History of Immunization',
            },
          ],
        },
        entry: refs,
      });

      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Immunization Record Linked',
          careContexts: [
            {
              display: 'Immunization Record' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'ImmunizationRecord',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  async createLabresults(
    labResults: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '736373009',
                  display: 'HealthDocumentRecord',
                },
              ],
              text: 'HealthDocumentRecord',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Prescription',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    if (labResults && labResults?.length > 0) {
      const refs = [];
      const entries = [];

      labResults.forEach((lab) => {
        const labId = uuidv4();
        refs.push({ reference: `urn:uuid:${labId}` });

        // convert observations to number if possible
        const numericVal = Number(lab.observations);

        const valueBlock: any = {};
        if (lab.unit && !isNaN(numericVal)) {
          valueBlock.valueQuantity = {
            value: numericVal,
            unit: lab.unit,
            system: 'http://unitsofmeasure.org',
            code: lab.unit,
          };
        } else if (!isNaN(numericVal)) {
          valueBlock.valueQuantity = {
            value: numericVal,
          };
        } else {
          valueBlock.valueString = lab.observations;
        }

        entries.push({
          fullUrl: `urn:uuid:${labId}`,
          resource: {
            resourceType: 'Observation',
            id: labId,
            status: 'final',
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Observation',
              ],
            },
            category: [
              {
                coding: [
                  {
                    system:
                      'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'laboratory',
                    display: 'Laboratory',
                  },
                ],
              },
            ],
            code: {
              coding: [
                {
                  system: 'http://loinc.org',
                  // Ideally map investigationName to proper LOINC
                  display: lab.investigationName,
                },
              ],
              text: lab.investigationName,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails?.patientName,
            },
            effectiveDateTime: new Date().toISOString(), // You can map test date if available
            ...valueBlock,
            interpretation: lab.interpretation
              ? [
                  {
                    coding: [
                      {
                        system:
                          'http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation',
                        display: lab.interpretation,
                      },
                    ],
                    text: lab.interpretation,
                  },
                ]
              : undefined,
            note: lab.additionalNotes
              ? [
                  {
                    text: lab.additionalNotes,
                  },
                ]
              : undefined,
            performer: [
              {
                actor: {
                  reference: `urn:uuid:${PractitionerID}`,
                  display: doctorDetails?.doctorName,
                },
              },
            ],
          },
        });
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Lab Results',
        code: {
          coding: [
            {
              system: 'http://loinc.org',
              code: '11502-2',
              display: 'Laboratory studies',
            },
          ],
        },
        entry: refs,
      });

      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'HealthDocumentRecord Linked',
          careContexts: [
            {
              display: 'HealthDocumentRecord' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'HealthDocumentRecord',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  async createInvoice(
    invoiceDetails: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
                  code: 'billing',
                  display: 'Billing Invoice',
                },
              ],
              text: 'Billing Invoice',
            },

            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Prescription',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };

    // if (invoiceDetails && invoiceDetails.length > 0) {
    //   const refs = [];
    //   const entries = [];

    //   invoiceDetails.forEach((inv) => {
    //     const invId = uuidv4();
    //     refs.push({ reference: `urn:uuid:${invId}` });

    //     entries.push({
    //       fullUrl: `urn:uuid:${invId}`,
    //       resource: {
    //         resourceType: 'Invoice',
    //         id: invId,
    //         status: 'issued', // issued / cancelled / entered-in-error
    //         meta: {
    //           profile: [
    //             'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Invoice',
    //           ],
    //         },
    //         type: {
    //           coding: [
    //             {
    //               system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //               code: 'billing',
    //               display: 'Billing Invoice',
    //             },
    //           ],
    //         },
    //         subject: {
    //           reference: `urn:uuid:${PatientID}`,
    //           display: patientDetails?.patientName,
    //         },
    //         date: new Date().toISOString(),
    //         participant: [
    //           {
    //             role: {
    //               coding: [
    //                 {
    //                   system:
    //                     'http://terminology.hl7.org/CodeSystem/participant-role',
    //                   code: 'performer',
    //                   display: 'Performer',
    //                 },
    //               ],
    //             },
    //             actor: {
    //               reference: `urn:uuid:${PractitionerID}`,
    //               display: doctorDetails?.doctorName,
    //             },
    //           },
    //         ],
    //         lineItem: [
    //           {
    //             sequence: 1,
    //             chargeItemCodeableConcept: {
    //               coding: [
    //                 {
    //                   system: 'http://example.org/fhir/invoice-items',
    //                   display: inv.itemName,
    //                 },
    //               ],
    //               text: inv.itemName,
    //             },
    //             quantity: {
    //               value: Number(inv.quantity) || 1,
    //               unit: inv.unit || 'unit',
    //             },
    //             priceComponent: [
    //               {
    //                 type: 'base',
    //                 amount: {
    //                   value: Number(inv.unitPrice) || 0,
    //                   currency: inv.currency || 'INR',
    //                 },
    //               },
    //             ],
    //             note: inv.notes
    //               ? [
    //                   {
    //                     text: inv.notes,
    //                   },
    //                 ]
    //               : undefined,
    //           },
    //         ],
    //         totalNet: {
    //           value: Number(inv.totalAmount) || 0,
    //           currency: inv.currency || 'INR',
    //         },
    //       },
    //     });
    //   });

    //   wellnessBundle.entry[0].resource.section.push({
    //     title: 'Invoices',
    //     code: {
    //       coding: [
    //         {
    //           system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //           code: 'billing',
    //           display: 'Invoice Section',
    //         },
    //       ],
    //     },
    //     entry: refs,
    //   });

    //   wellnessBundle.entry.push(...entries);
    // }

    // if (invoiceDetails && invoiceDetails.length > 0) {
    //   const refs = [];
    //   const entries = [];

    //   invoiceDetails.forEach((inv) => {
    //     const invId = uuidv4();
    //     refs.push({ reference: `urn:uuid:${invId}` });

    //     entries.push({
    //       fullUrl: `urn:uuid:${invId}`,
    //       resource: {
    //         resourceType: 'Invoice',
    //         id: invId,
    //         status: 'issued',
    //         meta: {
    //           profile: [
    //             'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Invoice',
    //           ],
    //         },
    //         type: {
    //           coding: [
    //             {
    //               system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //               code: 'billing',
    //               display: 'Billing Invoice',
    //             },
    //           ],
    //           text: 'Billing Invoice',
    //         },
    //         subject: {
    //           reference: `urn:uuid:${PatientID}`,
    //           display: patientDetails.patientName,
    //         },
    //         date: CurrDate,
    //         participant: [
    //           {
    //             actor: {
    //               reference: `urn:uuid:${PractitionerID}`,
    //               display: `Dr. ${doctorDetails.doctorName}`,
    //             },
    //           },
    //         ],
    //         lineItem: [
    //           {
    //             sequence: 1,
    //             chargeItemReference: {
    //               reference: invId,
    //               display: inv.itemName,
    //             },
    //             quantity: {
    //               value: inv.quantity,
    //             },
    //             unitPrice: {
    //               value: inv.unitPrice,
    //               currency: 'INR',
    //             },
    //             net: {
    //               value: inv.total,
    //               currency: 'INR',
    //             },
    //             note: [
    //               {
    //                 text: inv.note,
    //               },
    //             ],
    //           },
    //         ],
    //         totalGross: {
    //           value: invoiceDetails.reduce((acc, i) => acc + i.total, 0),
    //           currency: 'INR',
    //         },
    //       },
    //     });
    //   });

    //   wellnessBundle.entry[0].resource.section.push({
    //     title: 'Invoice',
    //     code: {
    //       coding: [
    //         {
    //           system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //           code: 'billing',
    //           display: 'Billing Invoice',
    //         },
    //       ],
    //     },
    //     entry: refs,
    //   });

    //   wellnessBundle.entry.push(...entries);
    // }

    // if (invoiceDetails && invoiceDetails.length > 0) {
    //   const refs = [];
    //   const entries = [];

    //   const totalGross = invoiceDetails.reduce((acc, i) => acc + i.total, 0);

    //   // Create a single Invoice resource
    //   const invId = uuidv4();
    //   refs.push({ reference: `urn:uuid:${invId}` });

    //   const lineItems = invoiceDetails.map((inv, index) => {
    //     const chargeItemId = uuidv4();

    //     // Create ChargeItem resource
    //     entries.push({
    //       fullUrl: `urn:uuid:${chargeItemId}`,
    //       resource: {
    //         resourceType: 'ChargeItem',
    //         id: chargeItemId,
    //         status: 'billable',
    //         code: {
    //           coding: [
    //             {
    //               system: 'http://example.org/invoice-items',
    //               code: inv.itemName.replace(/\s+/g, '_').toLowerCase(),
    //               display: inv.itemName,
    //             },
    //           ],
    //           text: inv.itemName,
    //         },
    //         subject: {
    //           reference: `urn:uuid:${PatientID}`,
    //           display: patientDetails.patientName,
    //         },
    //         quantity: {
    //           value: inv.quantity,
    //           unit: 'unit',
    //         },
    //         priceOverride: {
    //           value: inv.unitPrice,
    //           currency: 'INR',
    //         },
    //         note: inv.note
    //           ? [
    //               {
    //                 text: inv.note,
    //               },
    //             ]
    //           : undefined,
    //       },
    //     });

    //     return {
    //       sequence: index + 1,
    //       chargeItemReference: {
    //         reference: `urn:uuid:${chargeItemId}`,
    //         display: inv.itemName,
    //       },
    //       quantity: {
    //         value: inv.quantity,
    //         unit: 'unit',
    //       },
    //       unitPrice: {
    //         value: inv.unitPrice,
    //         currency: 'INR',
    //       },
    //       net: {
    //         value: inv.total,
    //         currency: 'INR',
    //       },
    //     };
    //   });

    //   // Create Invoice resource
    //   entries.push({
    //     fullUrl: `urn:uuid:${invId}`,
    //     resource: {
    //       resourceType: 'Invoice',
    //       id: invId,
    //       status: 'issued',
    //       meta: {
    //         profile: [
    //           'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Invoice',
    //         ],
    //       },
    //       type: {
    //         coding: [
    //           {
    //             system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //             code: 'billing',
    //             display: 'Billing Invoice',
    //           },
    //         ],
    //         text: 'Billing Invoice',
    //       },
    //       subject: {
    //         reference: `urn:uuid:${PatientID}`,
    //         display: patientDetails.patientName,
    //       },
    //       date: CurrDate,
    //       participant: [
    //         {
    //           actor: {
    //             reference: `urn:uuid:${PractitionerID}`,
    //             display: `Dr. ${doctorDetails.doctorName}`,
    //           },
    //         },
    //       ],
    //       lineItem: lineItems,
    //       totalGross: {
    //         value: totalGross,
    //         currency: 'INR',
    //       },
    //     },
    //   });

    //   wellnessBundle.entry[0].resource.section.push({
    //     title: 'Invoice',
    //     code: {
    //       coding: [
    //         {
    //           system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
    //           code: 'billing',
    //           display: 'Billing Invoice',
    //         },
    //       ],
    //     },
    //     entry: refs,
    //   });

    //   wellnessBundle.entry.push(...entries);
    // }

    if (invoiceDetails && invoiceDetails.length > 0) {
      const refs = [];
      const entries = [];

      const totalGross = invoiceDetails.reduce(
        (acc, i) => acc + Number(i.total || 0),
        0,
      );

      // Create a single Invoice resource
      const invId = uuidv4();
      refs.push({ reference: `urn:uuid:${invId}` });

      const lineItems = invoiceDetails.map((inv, index) => {
        const chargeItemId = uuidv4();

        // Create ChargeItem resource
        entries.push({
          fullUrl: `urn:uuid:${chargeItemId}`,
          resource: {
            resourceType: 'ChargeItem',
            id: chargeItemId,
            status: 'billable',
            code: {
              coding: [
                {
                  system: 'http://example.org/invoice-items',
                  code: inv.itemName
                    ? inv.itemName.replace(/\s+/g, '_').toLowerCase()
                    : 'na',
                  display: inv.itemName || 'NA',
                },
              ],
              text: inv.itemName || 'NA',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            quantity: {
              value: Number(inv.quantity) || 0,
              unit: 'unit',
            },
            priceOverride: {
              value: Number(inv.unitPrice) || 0,
              currency: 'INR',
            },
            note: inv.note
              ? [
                  {
                    text: inv.note,
                  },
                ]
              : undefined,
          },
        });

        return {
          sequence: index + 1,
          chargeItemReference: {
            reference: `urn:uuid:${chargeItemId}`,
            display: inv.itemName || 'NA', // 🔑 ensures item name shows
          },
          quantity: {
            value: Number(inv.quantity) || 0,
            unit: 'unit',
          },
          unitPrice: {
            value: Number(inv.unitPrice) || 0,
            currency: 'INR',
          },
          net: {
            value: Number(inv.total) || 0, // 🔑 make sure it's numeric
            currency: 'INR',
          },
        };
      });

      // Create Invoice resource
      entries.push({
        fullUrl: `urn:uuid:${invId}`,
        resource: {
          resourceType: 'Invoice',
          id: invId,
          status: 'issued',
          meta: {
            profile: [
              'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Invoice',
            ],
          },
          type: {
            coding: [
              {
                system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
                code: 'billing',
                display: 'Billing Invoice',
              },
            ],
            text: 'Billing Invoice',
          },
          subject: {
            reference: `urn:uuid:${PatientID}`,
            display: patientDetails.patientName,
          },
          date: CurrDate,
          participant: [
            {
              actor: {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            },
          ],
          lineItem: lineItems,
          totalGross: {
            value: totalGross,
            currency: 'INR',
          },
        },
      });

      wellnessBundle.entry[0].resource.section.push({
        title: 'Invoice',
        code: {
          coding: [
            {
              system: 'http://terminology.hl7.org/CodeSystem/invoice-type',
              code: 'billing',
              display: 'Billing Invoice',
            },
          ],
        },
        entry: refs,
      });

      wellnessBundle.entry.push(...entries);
    }

    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Invoice',
          careContexts: [
            {
              display: 'Invoice' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'Invoice',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }

  async createOpConsultation(
    chiefComplaintsBasic: any[],
    getPastTreatHis: any,
    followupDetails: any,
    hospital_id: any,
    opd_id: any,
    file: any,
    abhaAddress: string,
    diet_plan: any,
    treatmentAdvice: any
  ) {
    console.log(file, "adsfasd");

    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();
    let ChifeCompIDs: string[] = [];
    let treatHisID = uuidv4();
    let followupId = uuidv4();
    let docRefId = uuidv4();


    let selectedSymptoms: any[] = [];

    if (chiefComplaintsBasic) {
      selectedSymptoms =
        await chiefComplaintsBasic;
    }
    const docs = await this.findAll(await file);

    if (selectedSymptoms) {
      selectedSymptoms.forEach((elem: any) => {
        ChifeCompIDs.push(uuidv4());
      });
    }
    let currDateObj = new Date(CurrDate);
    currDateObj.setDate(currDateObj.getDate() + 2);
    let updatedDate = currDateObj.toISOString();
    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),

      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: `${CompositionID}`,
            meta: {
              versionId: '1',
              lastUpdated: CurrDate,
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/OPConsultRecord',
              ],
            },
            language: 'en-IN',
            identifier: {
              system: 'https://ndhm.in/phr',
              value: uuidv4(),
            },
            status: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '371530004',
                  display: 'Clinical consultation report',
                },
              ],
              text: 'Clinical Consultation report',
            },
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: doctorDetails.doctorName,
              },
            ],
            title: 'Consultation Report',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: await getHosDetails.hospital_name,
            },
            section: [
              {
                title: 'Chief complaints',
                code: {
                  coding: [
                    {
                      system: 'http://snomed.info/sct',
                      code: '422843007',
                      display: 'Chief complaint section',
                    },
                  ],
                },
                entry: [
                  ...ChifeCompIDs.map((comp: any, i: number) => ({
                    reference: `urn:uuid:${comp}`,
                    display: 'Condition',
                  })),
                ],
              },
              {
                title: 'Medical History',
                code: {
                  coding: [
                    {
                      system: 'http://snomed.info/sct',
                      code: '371529009',
                      display: 'History and physical report',
                    },
                  ],
                },
                entry: [
                  {
                    reference: `urn:uuid:${treatHisID}`,
                    display: 'Condition',
                  },
                ],
              },
              {
                title: 'Follow Up',
                code: {
                  coding: [
                    {
                      system: 'http://snomed.info/sct',
                      code: '736271009',
                      display: 'Outpatient care plan',
                    },
                  ],
                },
                entry: [
                  {
                    reference: `urn:uuid:${followupId}`,
                    display: 'Appointment',
                  },
                ],
              },
              {
                title: 'Document Reference',
                code: {
                  coding: [
                    {
                      system: 'http://snomed.info/sct',
                      code: '371530004',
                      display: 'Clinical consultation report',
                    },
                  ],
                },
                entry: [
                  {
                    reference: `urn:uuid:${docRefId}`,
                    display: 'DocumentReference',
                  },
                ],
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            meta: {
              versionId: '1',
              lastUpdated: CurrDate,
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Practitioner',
              ],
            },
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: doctorDetails.doctorName,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Organization',
              ],
            },
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: '4567823',
              },
            ],
            name: await getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: String(await getHosDetails.contact_no),
                use: 'work',
              },
              {
                system: 'email',
                value: await getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            meta: {
              versionId: '1',
              lastUpdated: '2020-07-09T14:58:58.181+05:30',
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Patient',
              ],
            },
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: '22-7225-4829-5255',
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: patientDetails.mobileno,
                use: 'home',
              },
            ],
            gender: patientDetails?.gender.toLocaleLowerCase(),
            birthDate: patientDetails?.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: `${EncounterID}`,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        ...selectedSymptoms.map((symps: any, i: number) => ({
          fullUrl: `urn:uuid:${ChifeCompIDs[i]}`,
          resource: {
            resourceType: 'Condition',
            id: ChifeCompIDs[i],
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Condition',
              ],
            },
            clinicalStatus: {
              coding: [
                {
                  system:
                    'http://terminology.hl7.org/CodeSystem/condition-clinical',
                  code: 'active',
                  display: 'Active',
                },
              ],
            },
            code: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '297142003',
                  display: symps?.complaints_name,
                },
              ],
              text: symps?.complaints_name,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: 'Patient',
            },
            recordedDate: CurrDate,
          },
        })),

        {
          fullUrl: `urn:uuid:${treatHisID}`,
          resource: {
            resourceType: 'Condition',
            id: treatHisID,
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Condition',
              ],
            },
            clinicalStatus: {
              coding: [
                {
                  system:
                    'http://terminology.hl7.org/CodeSystem/condition-clinical',
                  code: 'recurrence',
                  display: 'Recurrence',
                },
              ],
            },
            code: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '46635009',
                  display: getPastTreatHis?.history || 'Past treatment history',
                },
              ],
              text: getPastTreatHis?.history || 'Past treatment history',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: 'Patient',
            },
            recordedDate: CurrDate,
          },
        },
        {
          fullUrl: `urn:uuid:${followupId}`,
          resource: {
            resourceType: 'Appointment',
            id: followupId,
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/Appointment',
              ],
            },
            status: 'booked',
            serviceCategory: [
              {
                coding: [
                  {
                    system: 'http://snomed.info/sct',
                    code: '408443003',
                    display: 'General medical practice',
                  },
                ],
              },
            ],
            serviceType: [
              {
                coding: [
                  {
                    system: 'http://snomed.info/sct',
                    code: '11429006',
                    display: 'Consultation',
                  },
                ],
              },
            ],
            appointmentType: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '185389009',
                  display: 'Follow-up visit',
                },
              ],
            },
            reasonReference: [
              {
                reference: `urn:uuid:${uuidv4()}`,
                display: 'Condition',
              },
            ],
            description:
              (await followupDetails?.remarks) || 'remarks of the follow up',
            start: CurrDate,
            end: followupDetails.bundleDate || updatedDate,
            created: CurrDate,
            basedOn: [
              {
                reference: `urn:uuid:${uuidv4()}`,
                display: 'ServiceRequest',
              },
            ],
            participant: [
              {
                actor: {
                  reference: `urn:uuid:${PatientID}`,
                  display: 'Patient',
                },
                status: 'accepted',
              },
              {
                actor: {
                  reference: `urn:uuid:${PractitionerID}`,
                  display: 'Practitioner',
                },
                status: 'accepted',
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${docRefId}`,
          resource: {
            resourceType: 'DocumentReference',
            id: docRefId,
            meta: {
              profile: [
                'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentReference',
              ],
            },
            status: 'current',
            docStatus: 'final',
            type: {
              coding: [
                {
                  system: 'http://snomed.info/sct',
                  code: '4241000179101',
                  display: 'consult note',
                },
              ],
              text: file.split('.')[0],
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: 'Patient',
            },
            content: [
              {
                attachment: {
                  contentType: 'application/pdf',
                  language: 'en-IN',
                  data: docs,
                  title: file.originalname,
                  creation: CurrDate,
                },
              },
            ],
          },
        },
      ],
    };

    if (diet_plan) {
      let dietPlanId = uuidv4();

      wellnessBundle.entry[0].resource.section.push({
        title: 'Diet Plan',
        code: {
          coding: [
            {
              system: 'http://snomed.info/sct',
              code: '229065009',
              display: 'Dietary advice',
            },
          ],
        },
        entry: [
          {
            reference: `urn:uuid:${dietPlanId}`,
            display: 'Observation',
          },
        ],
      },)
      wellnessBundle.entry.push({
        fullUrl: `urn:uuid:${dietPlanId}`,
        resource: {
          resourceType: 'Observation',
          id: dietPlanId,
          status: 'final',
          code: {
            coding: [
              {
                system: 'http://snomed.info/sct',
                code: '229065009',
                display: 'Dietary advice',
              },
            ],
            text: 'Diet Plan',
          },
          subject: {
            reference: `urn:uuid:${PatientID}`,
            display: 'Patient',
          },
          effectiveDateTime: CurrDate,
          valueString: diet_plan?.dietPlan || 'General diet advice',
        },
      })
    }



    if (treatmentAdvice) {
      let treatmentAdviceId = uuidv4();

      wellnessBundle.entry[0].resource.section.push({
        title: 'Treatment Advice',
        code: {
          coding: [
            {
              system: 'http://snomed.info/sct',
              code: '281094005',
              display: 'Advice about treatment',
            },
          ],
        },
        entry: [
          {
            reference: `urn:uuid:${treatmentAdviceId}`,
            display: 'Observation',
          },
        ],
      },
      )
      wellnessBundle.entry.push({
        fullUrl: `urn:uuid:${treatmentAdviceId}`,
        resource: {
          resourceType: 'Observation',
          id: treatmentAdviceId,
          status: 'final',
          code: {
            coding: [
              {
                system: 'http://snomed.info/sct',
                code: '281094005',
                display: 'Advice about treatment',
              },
            ],
            text: 'Treatment Advice',
          },
          subject: {
            reference: `urn:uuid:${PatientID}`,
            display: 'Patient',
          },
          effectiveDateTime: CurrDate,
          valueString: treatmentAdvice || 'General treatment advice',
        },
      },
      )
    }



    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'OPConsultation Record Linked',
          careContexts: [
            {
              display: 'OPConsultation Record' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'OPConsultation',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }



  async createDiagnosis(
    diagnosisDetails: any[],
    hospital_id: any,
    opd_id: any,
    abhaAddress: string,
  ) {
    if (!hospital_id) {
      return {
        status: 'failed',
        message: 'enter hospital_id to post clinical notes',
      };
    }

    const [getPatientID] = await this.dynamicConnection.query(
      `select patient_id from opd_details where id = ?`,
      [opd_id],
    );

    const [checkPatientAbhaAddress] = await this.dynamicConnection.query(
      `select * from patient_abha_address where abhaAddress = ?`,
      [abhaAddress],
    );

    const [getPatDOB] = await this.dynamicConnection.query(
      `select * from patients where id = ?`,
      [getPatientID.patient_id],
    );

    let yob;
    if (getPatDOB.dob) {
      const [getYob] = await this.dynamicConnection.query(
        `SELECT YEAR(dob) AS year FROM patients where id = ?`,
        [getPatientID.patient_id],
      );
      yob = getYob.year;
    }

    const [patientDetails] = await this.dynamicConnection.query(
      `select patients.id,
      coalesce(patients.patient_name,"-") patientName,
      coalesce(DATE_FORMAT(patients.dob, '%D %b %Y'),"-") dob,
      date(patients.dob) bundleDate,
      coalesce(patients.age,"-") age,
      coalesce(patients.mobileno,"-") mobileno,
      coalesce(patients.email,"-") email,
      coalesce(patients.gender,"-") gender,
      coalesce(patients.abha_address,"-") abha_address,
      coalesce(patients.address,"-") address,
      coalesce(blood_bank_products.name,"-") patient_blood_group 
    from patients 
    left join blood_bank_products 
      on patients.blood_bank_product_id = blood_bank_products.id 
    where patients.id = ?`,
      [getPatientID.patient_id],
    );

    const [getDocId] = await this.dynamicConnection.query(
      `select cons_doctor from visit_details where opd_details_id = ?`,
      [opd_id],
    );

    const [doctorDetails] = await this.dynamicConnection.query(
      `select concat(staff.name," ",staff.surname) doctorName,staff.employee_id,staff.gender 
    from staff where id = ?`,
      [getDocId.cons_doctor],
    );

    const bundleDate = new Date(patientDetails.bundleDate);
    const options = {
      year: 'numeric' as const,
      month: '2-digit' as const,
      day: '2-digit' as const,
      hour: '2-digit' as const,
      minute: '2-digit' as const,
      second: '2-digit' as const,
      hourCycle: 'h23' as const,
      timeZone: 'Asia/Kolkata',
    };

    const new_bundle_Date = new Intl.DateTimeFormat('en-CA', options).format(
      bundleDate,
    );
    const [date, time] = new_bundle_Date.split(', ');
    const isoDate = `${date}T${time}`;
    const finaldob = isoDate.split('T')[0];
    patientDetails.bundleDate = finaldob;

    const [getHosDetails] = await this.connection.query(
      `select * from hospitals where plenome_id = ?`,
      [hospital_id],
    );
    const [getHosHipId] = await this.connection.query(
      `select hip_id from hospitals where plenome_id = ?`,
      [hospital_id],
    );

    let CurrDate = new Date().toISOString();
    let CompositionID = uuidv4();
    let PractitionerID = uuidv4();
    let PatientID = uuidv4();
    let OrgtID = uuidv4();
    let EncounterID = uuidv4();

    let wellnessBundle: any = {
      resourceType: 'Bundle',
      id: uuidv4(),
      meta: {
        versionId: '1',
        lastUpdated: CurrDate,
        profile: [
          'https://nrces.in/ndhm/fhir/r4/StructureDefinition/DocumentBundle',
        ],
        security: [
          {
            system: 'http://terminology.hl7.org/CodeSystem/v3-Confidentiality',
            code: 'V',
            display: 'very restricted',
          },
        ],
      },
      identifier: {
        system: 'http://hip.in',
        value: uuidv4(),
      },
      type: 'document',
      timestamp: CurrDate,
      entry: [
        {
          fullUrl: `urn:uuid:${CompositionID}`,
          resource: {
            resourceType: 'Composition',
            id: CompositionID,
            language: 'en-IN',
            identifier: [
              {
                system: 'https://ndhm.in/phr',
                value: uuidv4(),
              },
            ],
            status: 'final',
            "type": {
              "coding": [
                {
                  "system": "http://snomed.info/sct",
                  "code": "371525003",
                  "display": "Diagnostic report (record artifact)"
                }
              ],
              "text": "Diagnostic Report"
            }
            ,
            encounter: {
              reference: `urn:uuid:${EncounterID}`,
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
              display: patientDetails.patientName,
            },
            date: CurrDate,
            author: [
              {
                reference: `urn:uuid:${PractitionerID}`,
                display: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
            title: 'Diagnostic Report Record',
            custodian: {
              reference: `urn:uuid:${OrgtID}`,
              display: getHosDetails.hospital_name,
            },
            section: [],
          },
        },
        {
          fullUrl: `urn:uuid:${PractitionerID}`,
          resource: {
            resourceType: 'Practitioner',
            id: PractitionerID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MD',
                      display: 'Medical License number',
                    },
                  ],
                },
                system: 'https://doctor.ndhm.gov.in',
                value: doctorDetails.employee_id || '21-1521-3828-3227',
              },
            ],
            name: [
              {
                text: `Dr. ${doctorDetails.doctorName}`,
              },
            ],
          },
        },
        {
          fullUrl: `urn:uuid:${PatientID}`,
          resource: {
            resourceType: 'Patient',
            id: PatientID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'MR',
                      display: 'Medical record number',
                    },
                  ],
                },
                system: 'https://healthid.ndhm.gov.in',
                value: patientDetails.abha_address || uuidv4(),
              },
            ],
            name: [
              {
                text: patientDetails.patientName,
              },
            ],
            telecom: [
              {
                system: 'phone',
                value: String(patientDetails.mobileno),
                use: 'home',
              },
            ],
            gender: patientDetails.gender?.toLowerCase(),
            birthDate: patientDetails.bundleDate,
          },
        },
        {
          fullUrl: `urn:uuid:${EncounterID}`,
          resource: {
            resourceType: 'Encounter',
            id: EncounterID,
            status: 'finished',
            class: {
              system: 'http://terminology.hl7.org/CodeSystem/v3-ActCode',
              code: 'AMB',
              display: 'OPD Visit',
            },
            subject: {
              reference: `urn:uuid:${PatientID}`,
            },
            period: {
              start: CurrDate,
            },
          },
        },
        {
          fullUrl: `urn:uuid:${OrgtID}`,
          resource: {
            resourceType: 'Organization',
            id: OrgtID,
            identifier: [
              {
                type: {
                  coding: [
                    {
                      system: 'http://terminology.hl7.org/CodeSystem/v2-0203',
                      code: 'PRN',
                      display: 'Provider number',
                    },
                  ],
                },
                system: 'https://facility.ndhm.gov.in',
                value: String(getHosDetails.plenome_id) || '4567823',
              },
            ],
            name: getHosDetails.hospital_name,
            telecom: [
              {
                system: 'phone',
                value: getHosDetails.contact_no,
                use: 'work',
              },
              {
                system: 'email',
                value: getHosDetails.email,
                use: 'work',
              },
            ],
          },
        },
      ],
    };


    if (diagnosisDetails && diagnosisDetails?.length > 0) {
      const refs = [];
      const entries = [];

      // Create one DiagnosticReport ID
      const DiagnosticReportID = uuidv4();

      // Track unique labs
      const labSet = new Set();

      // Build Observation resources for each test
      diagnosisDetails.forEach((diag) => {
        const ObservationID = uuidv4();
        refs.push({ reference: `urn:uuid:${ObservationID}` });

        if (diag.labName) labSet.add(diag.labName);

        entries.push({
          fullUrl: `urn:uuid:${ObservationID}`,
          resource: {
            resourceType: 'Observation',
            id: ObservationID,
            status: 'final',
            category: [
              {
                coding: [
                  {
                    system: 'http://terminology.hl7.org/CodeSystem/observation-category',
                    code: 'laboratory',
                    display: 'Laboratory',
                  },
                ],
                text: 'Laboratory',
              },
            ],
            code: {
              coding: [
                {
                  system: 'http://loinc.org',
                  code: diag.category || 'unknown',
                  display: diag.subCategory || 'Test',
                },
              ],
              text: diag.subCategory || 'Test',
            },
            subject: { reference: `urn:uuid:${PatientID}` },
            effectiveDateTime: CurrDate,
            valueQuantity: diag.value
              ? {
                value: Number(diag.value),
                unit: diag.unit || '',
                system: 'http://unitsofmeasure.org',
                code: diag.unit || '',
              }
              : undefined,
            note: diag.remarks ? [{ text: diag.remarks }] : [],
          },
        });
      });

      // Create one DiagnosticReport resource after loop
      entries.push({
        fullUrl: `urn:uuid:${DiagnosticReportID}`,
        resource: {
          resourceType: 'DiagnosticReport',
          id: DiagnosticReportID,
          status: 'final',
          category: [
            {
              coding: [
                {
                  system: 'http://terminology.hl7.org/CodeSystem/v2-0074',
                  code: 'LAB',
                  display: 'Laboratory',
                },
              ],
              text: 'Laboratory',
            },
          ],
          code: {
            coding: [
              {
                system: 'http://loinc.org',
                code: '11502-2',
                display: 'Laboratory Report',
              },
            ],
            text: 'Lab Report',
          },
          subject: { reference: `urn:uuid:${PatientID}` },
          effectiveDateTime: CurrDate,
          issuer: {
            reference: `urn:uuid:${OrgtID}`,
            display: getHosDetails.hospital_name || 'Hospital',
          },
          performer: Array.from(labSet).map((labName) => {
            const labOrgId = uuidv4();
            entries.push({
              fullUrl: `urn:uuid:${labOrgId}`,
              resource: {
                resourceType: 'Organization',
                id: labOrgId,
                name: labName,
              },
            });
            return { reference: `urn:uuid:${labOrgId}`, display: labName };
          }),
          result: refs, // links to Observations
        },
      });

      // Add section in Composition
      wellnessBundle.entry[0].resource.section.push({
        title: 'Diagnostic Report',
        code: {
          coding: [
            {
              system: 'http://loinc.org',
              code: '10160-0',
              display: 'Diagnostic Report',
            },
          ],
        },
        entry: [{ reference: `urn:uuid:${DiagnosticReportID}` }],
      });

      wellnessBundle.entry.push(...entries);
    }





    const uploadWellnessBody = {
      value: wellnessBundle,
    };

    const response1 = await axios.post(
      'https://abha-api.plenome.com/file_upload',
      uploadWellnessBody,
    );
    const currentDate = new Date();
    const formattedDate = currentDate.toISOString().split('T')[0];

    const carecontext_reqbody = {
      // "abhaNumber": "91287816066859",    //optional
      abhaAddress: abhaAddress,
      patient_ref_no: await getPatDOB.aayush_unique_id,
      patient: [
        {
          display: 'Diagnostic Report Linked',
          careContexts: [
            {
              display: 'Diagnostic Report' + formattedDate,
              doc_key: response1.data.data,
            },
          ],

          hiType: 'DiagnosticReport',
          count: 1,
        },
      ],
    };
    if (
      abhaAddress &&
      abhaAddress.trim() != '' &&
      abhaAddress.toLocaleLowerCase() != 'null'
    ) {
      if (getPatientID.patient_id == checkPatientAbhaAddress.patient_id) {
        const PatientDetails = await patientDetails;

        if (
          checkPatientAbhaAddress.link_token_updated_date &&
          checkPatientAbhaAddress.linkToken
        ) {
          const givenDate = new Date(
            checkPatientAbhaAddress.link_token_updated_date,
          ); // Replace with your date
          const currentDate = new Date();

          // Set time to 00:00:00 for both dates to avoid time issues
          currentDate.setHours(0, 0, 0, 0);
          givenDate.setHours(0, 0, 0, 0);

          // Calculate the difference in months
          const monthDifference =
            (currentDate.getFullYear() - givenDate.getFullYear()) * 12 +
            currentDate.getMonth() -
            givenDate.getMonth();

          if (monthDifference > 5) {
            const getPatnameBody = {
              abhaAddress: abhaAddress,
            };

            const getname = await axios.post(
              'https://abha-api.plenome.com/m1-abha-address-verification',
              getPatnameBody,
            );

            const PatName = await getname.data.fullName;
            let patGender;
            if (
              PatientDetails.gender.toLocaleLowerCase() == 'male' ||
              PatientDetails.gender.toLocaleLowerCase() == 'm'
            ) {
              patGender = 'M';
            } else if (
              PatientDetails.gender.toLocaleLowerCase() == 'female' ||
              PatientDetails.gender.toLocaleLowerCase() == 'f'
            ) {
              patGender = 'F';
            } else {
              patGender = 'O';
            }

            const getLinkTokenBody = {
              name: await PatName,
              gender: await patGender,
              yearOfBirth: await yob,
              abhaAddress: abhaAddress,
            };
            const headers = {
              'X-HIP-ID': await getHosHipId.hip_id,
              'Content-Type': 'application/json',
            };
            console.log('getLinkTokenBody', getLinkTokenBody);

            const getLinkToken = await axios.post(
              'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
              getLinkTokenBody,
              { headers },
            );
            console.log(getLinkToken, "getLinkToken");

            this.updateLinkToken(
              hospital_id,
              getLinkToken.data[0].response[0].payload.linkToken,
              abhaAddress,
            );
          }
        } else {
          const getPatnameBody = {
            abhaAddress: abhaAddress,
          };

          const getname = await axios.post(
            'https://abha-api.plenome.com/m1-abha-address-verification',
            getPatnameBody,
          );

          const PatName = await getname.data.fullName;
          let patGender;
          if (
            PatientDetails.gender.toLocaleLowerCase() == 'male' ||
            PatientDetails.gender.toLocaleLowerCase() == 'm'
          ) {
            patGender = 'M';
          } else if (
            PatientDetails.gender.toLocaleLowerCase() == 'female' ||
            PatientDetails.gender.toLocaleLowerCase() == 'f'
          ) {
            patGender = 'F';
          } else {
            patGender = 'O';
          }

          const [getHosHipId] = await this.connection.query(
            `select hip_id from hospitals where plenome_id = ?`,
            [hospital_id],
          );

          const getLinkTokenBody = {
            name: await PatName,
            gender: await patGender,
            yearOfBirth: await yob,
            abhaAddress: abhaAddress,
          };

          const headers = {
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          const getLinkToken = await axios.post(
            'https://abha-api.plenome.com/hiecm/api/v3/generate-token',
            getLinkTokenBody,
            { headers },
          );
          console.log('asdffffffffdsaasdf');

          await this.updateLinkToken(
            hospital_id,
            getLinkToken.data[0].response[0].payload.linkToken,
            abhaAddress,
          );
        }
        const existing_link_token: any = await this.getexistingLinkToken(
          hospital_id,
          abhaAddress,
        );

        console.log(
          1,
          existing_link_token.linkToken,
          'existing_link_token.linkToken',
        );

        if (existing_link_token.linkToken) {
          console.log(
            existing_link_token.linkToken,
            'existing_link_token.linkToken',
          );

          const cc_headers = {
            'X-LINK-TOKEN': await existing_link_token.linkToken,
            'X-HIP-ID': await getHosHipId.hip_id,
            'Content-Type': 'application/json',
          };
          await axios.post(
            'https://abha-api.plenome.com/link/carecontext',
            carecontext_reqbody,
            { headers: cc_headers },
          );
        }
      }
    } else {
      const cc_headers = {
        'X-LINK-TOKEN': 'Temp_linktoken',
        'X-HIP-ID': await getHosHipId.hip_id,
        'Content-Type': 'application/json',
      };
      console.log(cc_headers, 'cc_headers');
      try {
        console.log('carecontext_reqbody', carecontext_reqbody);

        await axios.post(
          'https://abha-api.plenome.com/link/carecontext',
          carecontext_reqbody,
          { headers: cc_headers },
        );
      } catch (error) {
        console.log(error, 'error1111');
      }
      //  await axios.post(
      //   "https://abha-api.plenome.com/link/carecontext",
      //   carecontext_reqbody,
      //   { headers: cc_headers }
      // );
    }
    return wellnessBundle;
  }




  async updateLinkToken(
    hospital_id: number,
    token: string,
    abhaAddress: string,
  ) {
    try {
      await this.dynamicConnection.query(
        `update patient_abha_address set linkToken = ?,
            link_token_updated_date = date(now()) where abhaAddress = ?`,
        [token, abhaAddress],
      );
    } catch (error) {
      console.log(error);
    }
  }

  async getexistingLinkToken(hospital_id: number, abhaAddress: string) {
    try {
      const [existing_link_token] = await this.dynamicConnection.query(
        `select linkToken from patient_abha_address where abhaAddress = ?`,
        [abhaAddress],
      );
      return existing_link_token;
    } catch (error) {
      console.log(error);
    }
  }

  async findAll(value: string) {
    try {
      const s3 = new S3({
        credentials: {
          accessKeyId: awsConfig.accessKeyId,
          secretAccessKey: awsConfig.secretAccessKey,
        },
        region: awsConfig.region,
      });

      const command = new GetObjectCommand({
        Bucket: awsConfig.bucketName,
        Key: value,
      });

      const s3Data = await s3.send(command);

      const buffer = Buffer.from(await s3Data.Body.transformToByteArray());
      return buffer.toString('base64');
    } catch (error) {
      console.error(error);
      return error;
    }
  }

  findOne(id: number) {
    return `This action returns a #${id} opHubBundleGeneration`;
  }

  update(
    id: number,
    updateOpHubBundleGenerationDto: UpdateOpHubBundleGenerationDto,
  ) {
    return `This action updates a #${id} opHubBundleGeneration`;
  }

  remove(id: number) {
    return `This action removes a #${id} opHubBundleGeneration`;
  }
}
