import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { OpHubBundleGenerationService } from './op-hub-bundle-generation.service';
import { CreateOpHubBundleGenerationDto } from './dto/create-op-hub-bundle-generation.dto';
import { UpdateOpHubBundleGenerationDto } from './dto/update-op-hub-bundle-generation.dto';

@Controller('op-hub-bundle-generation')
export class OpHubBundleGenerationController {
  constructor(
    private readonly opHubBundleGenerationService: OpHubBundleGenerationService,
  ) {}

  @Post('/wellness')
  create(
    @Body('followupDetails') followupDetails: any,
    @Body('other_observations') other_observations: any,
    @Body('Lifestyle') Lifestyle: any,
    @Body('women_health') women_health: any,
    @Body('generalAssment') generalAssment: any,
    @Body('physicalActivity') physicalActivity: any,
    @Body('vitalDetails') vitalDetails: any,
    @Body('body_measurement') body_measurement: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.create(
      followupDetails,
      other_observations,
      Lifestyle,
      women_health,
      generalAssment,
      physicalActivity,
      vitalDetails,
      body_measurement,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/discharge_summary')
  createDischargeSummary(
    @Body('followupDetails') followupDetails: any,
    @Body('clinicalPresentation') clinicalPresentation: any,
    @Body('investigationsPerformed') investigationsPerformed: any,
    @Body('treatment_given') treatment_given: any,
    @Body('condition_at_discharge') condition_at_discharge: any,
    @Body('discharge_advice') discharge_advice: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createDischargeSummary(
      followupDetails,
      clinicalPresentation,
      investigationsPerformed,
      treatment_given,
      condition_at_discharge,
      discharge_advice,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/prescription')
  createPrescription(
    @Body('prescriptionDetails') prescriptionDetails: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createPrescription(
      prescriptionDetails,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/immunization')
  createImmunization(
    @Body('immunizationDetails') immunizationDetails: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createImmunization(
      immunizationDetails,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/labresults')
  createlabResults(
    @Body('labResults') labResults: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createLabresults(
      labResults,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/invoiceDetails')
  createinvoiceDetails(
    @Body('invoiceDetails') invoiceDetails: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createInvoice(
      invoiceDetails,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Post('/opConsultation')
  createOpConsultation(
    @Body('chiefComplaintsBasic') chiefComplaintsBasic: any,
    @Body('getPastTreatHis') getPastTreatHis: any,
    @Body('followupDetails') followupDetails: any,
    @Body('filename') file: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
    @Body('diet_plan') diet_plan: any,
    @Body('treatmentAdvice') treatmentAdvice: any,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    if (!file) {
      return {
        message: 'filename is required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createOpConsultation(
      chiefComplaintsBasic,
      getPastTreatHis,
      followupDetails,
      hospital_id,
      opd_id,
      file,
      abhaAddress,
      diet_plan,
      treatmentAdvice,
    );
  }

  @Post('/diagnosis_report')
  createDiagnosisReport(
    @Body('diagnosisDetails') prescriptionDetails: any,
    @Body('hospital_id') hospital_id: number,
    @Body('opd_id') opd_id: number,
    @Body('abhaAddress') abhaAddress: string,
  ) {
    if (!hospital_id || !opd_id) {
      return {
        message: 'hospital_id and opd_id are required',
        status: 'failed',
        statusCode: 400,
      };
    }
    return this.opHubBundleGenerationService.createDiagnosis(
      prescriptionDetails,
      hospital_id,
      opd_id,
      abhaAddress,
    );
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.opHubBundleGenerationService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateOpHubBundleGenerationDto: UpdateOpHubBundleGenerationDto,
  ) {
    return this.opHubBundleGenerationService.update(
      +id,
      updateOpHubBundleGenerationDto,
    );
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.opHubBundleGenerationService.remove(+id);
  }
}
