import { Module } from '@nestjs/common';
import { OpHubAppointmentService } from './op-hub-appointment.service';
import { OpHubAppointmentController } from './op-hub-appointment.controller';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
import { MongooseModule } from '@nestjs/mongoose';
import {
  TransactionSplit,
  TransactionSplitSchema,
} from 'src/transaction_split/entities/transaction_split.entity';
import { TransactionSplitService } from 'src/transaction_split/transaction_split.service';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: TransactionSplit.name, schema: TransactionSplitSchema },
    ]),
  ],
  controllers: [OpHubAppointmentController],
  providers: [
    OpHubAppointmentService,
    FaceAuthService,
    TransactionSplitService,
  ],
})
export class OpHubAppointmentModule {}
