import { Module } from '@nestjs/common';
import { NewBillingService } from './new-billing.service';
import { NewBillingController } from './new-billing.controller';
import {
  transaction_details,
  TransactiondetailsSchema,
} from './entities/new-billing.entity';
import { MongooseModule } from '@nestjs/mongoose';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CreateNewBillingDto } from './dto/create-new-billing.dto';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: transaction_details.name, schema: TransactiondetailsSchema },
    ]),
    TypeOrmModule.forFeature([CreateNewBillingDto]),
  ],
  controllers: [NewBillingController],
  providers: [NewBillingService],
})
export class NewBillingModule {}
