import { ApiHideProperty, ApiProperty } from '@nestjs/swagger';

export class NewBilling {}

export class makepaymentV3 {
  @ApiProperty({ example: 'razorpay' })
  payment_gateway: string;

  @ApiProperty({ example: 'rzp_liveZsdSe' })
  payment_id: string;

  @ApiProperty({ example: '24456552' })
  payment_reference_number: string;
  @ApiProperty({ example: 'CASH123456' })
  cash_transaction_id: string;
  @ApiProperty({ example: 1 })
  Hospital_id: number;

  @ApiProperty({ example: 2 })
  patient_id: any;

  @ApiProperty({ example: 'cash' })
  payment_mode: any;

  @ApiProperty({ example: '2024-09-06' })
  payment_date: any;

  @ApiProperty({ example: 'Elakkiya S' })
  received_by_name: string;

  @ApiProperty({ example: 'APPPN112' })
  sectionId: string;

  @ApiProperty({
    example: `[
     {
            "appointment_id": "APPN278",
            "module": "APPOINTMENT",
            "department_id": "APPN278",
            "charge_type": null,
            "name": null,
            "surname": null,
            "doctor_id": null,
            "case_id": 280,
            "patient_charge_id": 305,
            "billed_date": "2025-03-25T18:30:00.000Z",
            "billed_time": "00:00:00"
        },
        {
            "appointment_id": "APPN280",
            "module": "APPOINTMENT",
            "department_id": "APPN280",
            "charge_type": null,
            "name": null,
            "surname": null,
            "doctor_id": null,
            "case_id": 282,
            "patient_charge_id": 307,
            "billed_date": "2025-03-25T18:30:00.000Z",
            "billed_time": "00:00:00"
        }
    ]`,
  })
  paymentDetails: any;

  @ApiProperty({ example: 'Payment for services rendered' })
  totalDue: string;
  @ApiHideProperty()
  txn_id: any;

  @ApiHideProperty()
  pg_ref_id: any;

  @ApiHideProperty()
  bank_ref_id: any;

  @ApiProperty({ example: 'APPPN112' })
  payment_method: string;

  @ApiProperty({ example: 'APPPN112' })
  card_division: string;

  @ApiProperty({ example: 'APPPN112' })
  card_bank_name: string;

  @ApiProperty({ example: 'APPPN112' })
  card_type: string;
  @ApiProperty({ example: 'APPPN112' })
  card_transaction_id: string;
  @ApiProperty({ example: 'APPPN112' })
  net_banking_division: string;
  @ApiProperty({ example: 'APPPN112' })
  net_banking_transaction_id: string;
  @ApiProperty({ example: 'APPPN112' })
  upi_id: string;
  @ApiProperty({ example: 'APPPN112' })
  upi_transaction_id: string;
  @ApiProperty({ example: 'APPPN112' })
  upi_bank_name: string;
  @ApiProperty({ example: 'APPPN112' })
  amount_from_coins: string;
  @ApiProperty({ example: 'APPPN112' })
  actual_amount_paid: string;

  @ApiProperty({ example: 'APPPN112' })
  patient_details: any;
}

import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document } from 'mongoose';

export type TransactiondetailsDocument = transaction_details & Document;

@Schema({
  collection: process.env.server + '_transaction_details',
  timestamps: { createdAt: 'created_at' },
})
export class transaction_details {
  @Prop({ required: true })
  hospital_id: number;

  @Prop({ required: true })
  patient_aayush_id: string;

  @Prop({ required: true })
  plenome_transaction_id: string;

  @Prop({ required: true })
  hos_transaction_id: string;

  @Prop({ type: Array, required: false })
  transaction_details: any;

  @Prop({ type: Object, required: false })
  patient_details: any;

  @Prop({ type: Object, required: false })
  primary_cons_doctor: any;

  @Prop({ type: Object, required: false })
  last_cons_doctor: any;

  @Prop({ type: String, required: false })
  amount_paid: any;

  @Prop({ type: String, required: false })
  payment_mode: any;

  @Prop({ type: String, required: false })
  payment_status: any;

  @Prop({ type: String, required: false })
  payment_transaction_id: any;
}

export const TransactiondetailsSchema =
  SchemaFactory.createForClass(transaction_details);
