"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VisitorBookController = void 0;
const common_1 = require("@nestjs/common");
const visitor_book_service_1 = require("./visitor_book.service");
const visitor_book_entity_1 = require("./entities/visitor_book.entity");
const auth_guard_1 = require("../auth/auth.guard");
let VisitorBookController = class VisitorBookController {
    constructor(visitorBookService) {
        this.visitorBookService = visitorBookService;
    }
    create(createVisitorBook) {
        return this.visitorBookService.create(createVisitorBook);
    }
    update(id, createVisitorBook) {
        return this.visitorBookService.update(id, createVisitorBook);
    }
    async removeFrontofficeVisitors(id, hospital_id) {
        const deleteFrontoffiveVisitors = await this.visitorBookService.removeFrontofficeVisitors(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.VisitorBookController = VisitorBookController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [visitor_book_entity_1.VisitorBook]),
    __metadata("design:returntype", void 0)
], VisitorBookController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, visitor_book_entity_1.VisitorBook]),
    __metadata("design:returntype", void 0)
], VisitorBookController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/removeFrontofficeVisitors/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], VisitorBookController.prototype, "removeFrontofficeVisitors", null);
exports.VisitorBookController = VisitorBookController = __decorate([
    (0, common_1.Controller)('visitor-book'),
    __metadata("design:paramtypes", [visitor_book_service_1.VisitorBookService])
], VisitorBookController);
//# sourceMappingURL=visitor_book.controller.js.map