"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TpaManagementService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let TpaManagementService = class TpaManagementService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(tpa_managementEntity) {
        try {
            const result = await this.connection.query(`Insert into organisation (organisation_name,code,contact_no,address,contact_person_name,contact_person_phone) values (?,?,?,?,?,?)`, [tpa_managementEntity.organisation_name,
                tpa_managementEntity.code,
                tpa_managementEntity.contact_no,
                tpa_managementEntity.address,
                tpa_managementEntity.contact_person_name,
                tpa_managementEntity.contact_person_phone
            ]);
            const tpaid = result.insertId;
            await this.dynamicConnection.query(`insert into organisation 
      (organisation_name,code,contact_no,address,contact_person_name,
        contact_person_phone,Hospital_id,hos_organisation_id) values (?,?,?,?,?,?,?,?)`, [
                tpa_managementEntity.organisation_name,
                tpa_managementEntity.code,
                tpa_managementEntity.contact_no,
                tpa_managementEntity.address,
                tpa_managementEntity.contact_person_name,
                tpa_managementEntity.contact_person_phone,
                tpa_managementEntity.Hospital_id,
                tpaid
            ]);
            return [{
                    "data ": {
                        "id  ": tpaid,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.TPA_MANAGEMENT,
                        "inserted_data": await this.connection.query('SELECT * FROM organisation WHERE id = ?', [tpaid])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const TPA_management = await this.connection.query(`select organisation.id, organisation.organisation_name as name,organisation.code as code,organisation.contact_no as phone,organisation.address as Address,
  organisation.contact_person_name,organisation.contact_person_phone from organisation`);
            return TPA_management;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findone(id) {
        try {
            const TPA_management = await this.connection.query(`select organisation.id, organisation.organisation_name as name,organisation.code as code,organisation.contact_no as phone,organisation.address as Address,
organisation.contact_person_name,organisation.contact_person_phone from organisation where id = ? `, [id]);
            return TPA_management;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, tpa_managementEntity) {
        try {
            await this.connection.query(`UPDATE organisation SET organisation_name = ?, code = ?, contact_no = ?, address = ?, contact_person_name = ?, contact_person_phone = ? where id = ?`, [
                tpa_managementEntity.organisation_name,
                tpa_managementEntity.code,
                tpa_managementEntity.contact_no,
                tpa_managementEntity.address,
                tpa_managementEntity.contact_person_name,
                tpa_managementEntity.contact_person_phone,
                id
            ]);
            await this.dynamicConnection.query(`update organisation SET organisation_name = ?,code = ?, contact_no = ?, address = ?, contact_person_name = ?, contact_person_phone = ? 
      where Hospital_id = ? and hos_organisation_id = ? `, [
                tpa_managementEntity.organisation_name,
                tpa_managementEntity.code,
                tpa_managementEntity.contact_no,
                tpa_managementEntity.address,
                tpa_managementEntity.contact_person_name,
                tpa_managementEntity.contact_person_phone,
                tpa_managementEntity.Hospital_id,
                id
            ]);
            return [{
                    "data": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.TPA_MANAGEMENT_UPDATED,
                        "updated_values": await this.connection.query(`select * from organisation where id = ?`, [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hos_id) {
        try {
            await this.dynamicConnection.query(`update organisation set is_deleted = 1 where Hospital_id = ?
    and hos_organisation_id = ?`, [hos_id, id]);
            await this.connection.query(`delete from organisation where id = ?`, [id]);
            return [{
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.TpaManagementService = TpaManagementService;
exports.TpaManagementService = TpaManagementService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], TpaManagementService);
//# sourceMappingURL=tpa_management.service.js.map