"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenShedulerService = void 0;
const common_1 = require("@nestjs/common");
const cron = require("node-cron");
const op_hub_token_initiate_service_1 = require("../op-hub-token-initiate/op-hub-token-initiate.service");
let TokenShedulerService = class TokenShedulerService {
    constructor(tokenInitiateService) {
        this.tokenInitiateService = tokenInitiateService;
    }
    onModuleInit() {
        this.scheduleTokenInitiation();
    }
    scheduleTokenInitiation() {
        console.log('entering Function');
        cron.schedule('00 00 * * *', () => {
            console.log('Manually triggering task: Token initiation');
            this.tokenInitiateService
                .findAll()
                .then(() => {
                console.log('Manually triggered task: Token initiation completed');
            })
                .catch((error) => {
                console.error('Error occurred during manual task execution:', error);
            });
        });
    }
};
exports.TokenShedulerService = TokenShedulerService;
exports.TokenShedulerService = TokenShedulerService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [op_hub_token_initiate_service_1.OpHubTokenInitiateService])
], TokenShedulerService);
//# sourceMappingURL=token-sheduler.service.js.map