"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimelineIpdController = void 0;
const common_1 = require("@nestjs/common");
const timeline_ipd_service_1 = require("./timeline_ipd.service");
const timeline_ipd_entity_1 = require("./entities/timeline_ipd.entity");
let TimelineIpdController = class TimelineIpdController {
    constructor(timelineIpdService) {
        this.timelineIpdService = timelineIpdService;
    }
    create(createTimelineIpd) {
        return this.timelineIpdService.create(createTimelineIpd);
    }
    findOne(patient_id) {
        return this.timelineIpdService.findOne(patient_id);
    }
    update(id, createTimelineIpd) {
        return this.timelineIpdService.update(id, createTimelineIpd);
    }
    async removePatientTimeline(id, hospital_id) {
        await this.timelineIpdService.remove(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async findIpdTimelineDetails(patient_id, search, limit, page) {
        try {
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.timelineIpdService.findIpdTimelineDetails(patient_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.TimelineIpdController = TimelineIpdController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [timeline_ipd_entity_1.TimelineIpd]),
    __metadata("design:returntype", void 0)
], TimelineIpdController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('/patTimeline/:patient_id'),
    __param(0, (0, common_1.Param)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], TimelineIpdController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, timeline_ipd_entity_1.TimelineIpd]),
    __metadata("design:returntype", void 0)
], TimelineIpdController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], TimelineIpdController.prototype, "removePatientTimeline", null);
__decorate([
    (0, common_1.Get)('/v2/get_ipd_timeline'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], TimelineIpdController.prototype, "findIpdTimelineDetails", null);
exports.TimelineIpdController = TimelineIpdController = __decorate([
    (0, common_1.Controller)('timeline-ipd'),
    __metadata("design:paramtypes", [timeline_ipd_service_1.TimelineIpdService])
], TimelineIpdController);
//# sourceMappingURL=timeline_ipd.controller.js.map