"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaffIdCardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let StaffIdCardService = class StaffIdCardService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createStaffIdCard) {
        try {
            let Staff_ID_Card_id;
            const Staff_ID_Card = await this.connection.query(`INSERT into staff_id_card (
       title,
       hospital_name,
       hospital_address,
       background,
       logo,
       sign_image,
       header_color,
       enable_staff_role,
       enable_staff_id,
       enable_staff_department,
       enable_designation,
       enable_name,
       enable_fathers_name,
       enable_mothers_name,
       enable_date_of_joining,
       enable_permanent_address,
       enable_staff_dob,
       enable_staff_phone,
       status
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createStaffIdCard.title,
                createStaffIdCard.hospital_name,
                createStaffIdCard.hospital_address,
                createStaffIdCard.background,
                createStaffIdCard.logo,
                createStaffIdCard.sign_image,
                createStaffIdCard.header_color,
                createStaffIdCard.enable_staff_role,
                createStaffIdCard.enable_staff_id,
                createStaffIdCard.enable_staff_department,
                createStaffIdCard.enable_designation,
                createStaffIdCard.enable_name,
                createStaffIdCard.enable_fathers_name,
                createStaffIdCard.enable_mothers_name,
                createStaffIdCard.enable_date_of_joining,
                createStaffIdCard.enable_permanent_address,
                createStaffIdCard.enable_staff_dob,
                createStaffIdCard.enable_staff_phone,
                createStaffIdCard.status
            ]);
            Staff_ID_Card_id = Staff_ID_Card.insertId;
            await this.dynamicConnection.query(`INSERT into staff_id_card (
       title,
       hospital_name,
       hospital_address,
       background,
       logo,
       sign_image,
       header_color,
       enable_staff_role,
       enable_staff_id,
       enable_staff_department,
       enable_designation,
       enable_name,
       enable_fathers_name,
       enable_mothers_name,
       enable_date_of_joining,
       enable_permanent_address,
       enable_staff_dob,
       enable_staff_phone,
       status,
       hospital_id,
       hos_staff_id_card_id
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createStaffIdCard.title,
                createStaffIdCard.hospital_name,
                createStaffIdCard.hospital_address,
                createStaffIdCard.background,
                createStaffIdCard.logo,
                createStaffIdCard.sign_image,
                createStaffIdCard.header_color,
                createStaffIdCard.enable_staff_role,
                createStaffIdCard.enable_staff_id,
                createStaffIdCard.enable_staff_department,
                createStaffIdCard.enable_designation,
                createStaffIdCard.enable_name,
                createStaffIdCard.enable_fathers_name,
                createStaffIdCard.enable_mothers_name,
                createStaffIdCard.enable_date_of_joining,
                createStaffIdCard.enable_permanent_address,
                createStaffIdCard.enable_staff_dob,
                createStaffIdCard.enable_staff_phone,
                createStaffIdCard.status,
                createStaffIdCard.hospital_id,
                Staff_ID_Card_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Staff ID Card details added successfully ",
                        "Added_staff_id_card_values": await this.connection.query('SELECT * FROM staff_id_card where id = ?', [Staff_ID_Card_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async updateStaffIdCard(id, createStaffIdCard) {
        try {
            await this.connection.query(`update staff_id_card SET
       title=?,
       hospital_name=?,
       hospital_address=?,
       background=?,
       logo=?,
       sign_image=?,
       header_color=?,
       enable_staff_role=?,
       enable_staff_id=?,
       enable_staff_department=?,
       enable_designation=?,
       enable_name=?,
       enable_fathers_name=?,
       enable_mothers_name=?,
       enable_date_of_joining=?,
       enable_permanent_address=?,
       enable_staff_dob=?,
       enable_staff_phone=?,
       status=?
       where id=?`, [
                createStaffIdCard.title,
                createStaffIdCard.hospital_name,
                createStaffIdCard.hospital_address,
                createStaffIdCard.background,
                createStaffIdCard.logo,
                createStaffIdCard.sign_image,
                createStaffIdCard.header_color,
                createStaffIdCard.enable_staff_role,
                createStaffIdCard.enable_staff_id,
                createStaffIdCard.enable_staff_department,
                createStaffIdCard.enable_designation,
                createStaffIdCard.enable_name,
                createStaffIdCard.enable_fathers_name,
                createStaffIdCard.enable_mothers_name,
                createStaffIdCard.enable_date_of_joining,
                createStaffIdCard.enable_permanent_address,
                createStaffIdCard.enable_staff_dob,
                createStaffIdCard.enable_staff_phone,
                createStaffIdCard.status,
                id
            ]);
            const dynStaffIDCard = await this.dynamicConnection.query('SELECT id FROM staff_id_card WHERE hos_staff_id_card_id=? and hospital_id=?', [id, createStaffIdCard.hospital_id]);
            const dynStaffIDCardID = dynStaffIDCard[0].id;
            await this.dynamicConnection.query(`update staff_id_card SET
       title=?,
       hospital_name=?,
       hospital_address=?,
       background=?,
       logo=?,
       sign_image=?,
       header_color=?,
       enable_staff_role=?,
       enable_staff_id=?,
       enable_staff_department=?,
       enable_designation=?,
       enable_name=?,
       enable_fathers_name=?,
       enable_mothers_name=?,
       enable_date_of_joining=?,
       enable_permanent_address=?,
       enable_staff_dob=?,
       enable_staff_phone=?,
       status=?,
       hospital_id=?
       where id=?`, [
                createStaffIdCard.title,
                createStaffIdCard.hospital_name,
                createStaffIdCard.hospital_address,
                createStaffIdCard.background,
                createStaffIdCard.logo,
                createStaffIdCard.sign_image,
                createStaffIdCard.header_color,
                createStaffIdCard.enable_staff_role,
                createStaffIdCard.enable_staff_id,
                createStaffIdCard.enable_staff_department,
                createStaffIdCard.enable_designation,
                createStaffIdCard.enable_name,
                createStaffIdCard.enable_fathers_name,
                createStaffIdCard.enable_mothers_name,
                createStaffIdCard.enable_date_of_joining,
                createStaffIdCard.enable_permanent_address,
                createStaffIdCard.enable_staff_dob,
                createStaffIdCard.enable_staff_phone,
                createStaffIdCard.status,
                createStaffIdCard.hospital_id,
                dynStaffIDCardID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Staff ID card details updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM staff_id_card WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeStaffIDcard(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM staff_id_card WHERE id = ?', [id]);
            const [GetDynStaffidcard] = await this.dynamicConnection.query('SELECT id FROM staff_id_card WHERE hos_staff_id_card_id=? and hospital_id=?', [id, hospital_id]);
            const GetDynstaffidcardID = GetDynStaffidcard.id;
            await this.dynamicConnection.query('DELETE FROM staff_id_card WHERE id = ?', [GetDynstaffidcardID]);
            return [
                {
                    status: 'success',
                    message: `staff ID card with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.StaffIdCardService = StaffIdCardService;
exports.StaffIdCardService = StaffIdCardService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], StaffIdCardService);
//# sourceMappingURL=staff_id_card.service.js.map