"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaffAttendanceService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let StaffAttendanceService = class StaffAttendanceService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createStaffAttendanceArray) {
        try {
            const results = [];
            for (const createStaffAttendance of createStaffAttendanceArray) {
                const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [createStaffAttendance.staff_id]);
                if (!staffId || staffId.length === 0) {
                    throw new Error(`${process.env.VALIDATION_STAFF} ${createStaffAttendance.staff_id} ${process.env.VALIDATION_NOT_FOUND}`);
                }
                const docemail = staffId.email;
                const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
                const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
                const hosStaffAttendance = await this.connection.query(`INSERT INTO staff_attendance(
            date,
            staff_id,
            staff_attendance_type_id,
            remark,
            is_active
          ) VALUES(?,?,?,?,?)`, [
                    createStaffAttendance.date,
                    createStaffAttendance.staff_id,
                    createStaffAttendance.staff_attendance_type_id,
                    createStaffAttendance.remark,
                    1,
                ]);
                const HOSStaffAttendanceId = hosStaffAttendance.insertId;
                const addedStaffAttendanceDetails = await this.connection.query('SELECT * FROM staff_attendance WHERE id = ?', [HOSStaffAttendanceId]);
                const [AdminStaffAttendanceType] = await this.dynamicConnection.query('SELECT id FROM staff_attendance_type WHERE Hospital_id = ? and hos_staff_attendance_type_id = ?', [
                    createStaffAttendance.hospital_id,
                    createStaffAttendance.staff_attendance_type_id,
                ]);
                const ADMINstaffAttendanceTypeID = AdminStaffAttendanceType.id;
                await this.dynamicConnection.query(`INSERT INTO staff_attendance(
            date,
            staff_id,
            staff_attendance_type_id,
            remark,
            is_active,
            hospital_id,
            hos_staff_attendance_id
          ) VALUES(?,?,?,?,?,?,?)`, [
                    createStaffAttendance.date,
                    dynamicUPTDStaffId,
                    ADMINstaffAttendanceTypeID,
                    createStaffAttendance.remark,
                    1,
                    createStaffAttendance.hospital_id,
                    HOSStaffAttendanceId,
                ]);
                results.push({
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.STAFF_ATTENDANCE_MESSAGE,
                    Added_Staff_attendance_details: addedStaffAttendanceDetails,
                });
            }
            return results;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async updateStaffAttendance(createStaffAttendanceArray) {
        const currentdate = new Date();
        const formattedDate = currentdate.toISOString().split('T')[0];
        try {
            const results = [];
            for (const createStaffAttendance of createStaffAttendanceArray) {
                const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [createStaffAttendance.staff_id]);
                if (!staffId || staffId.length === 0) {
                    throw new Error(`${process.env.VALIDATION_STAFF} ${createStaffAttendance.staff_id} ${process.env.VALIDATION_NOT_FOUND}`);
                }
                const docemail = staffId.email;
                const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
                const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
                await this.connection.query(`UPDATE staff_attendance SET 
            date = ?,
            staff_id = ?,
            staff_attendance_type_id = ?,
            remark = ?,
            updated_at = ?
            WHERE id = ?`, [
                    createStaffAttendance.date,
                    createStaffAttendance.staff_id,
                    createStaffAttendance.staff_attendance_type_id,
                    createStaffAttendance.remark,
                    formattedDate,
                    createStaffAttendance.id,
                ]);
                const [updatedStaffAttendanceDetails] = await this.connection.query('SELECT * FROM staff_attendance WHERE id = ?', [createStaffAttendance.id]);
                const [adminStaffAttendanceTypeResult] = await this.dynamicConnection.query('SELECT id FROM staff_attendance_type WHERE hospital_id = ? AND hos_staff_attendance_type_id = ?', [
                    createStaffAttendance.hospital_id,
                    createStaffAttendance.staff_attendance_type_id,
                ]);
                const ADMINstaffAttendanceTypeID = adminStaffAttendanceTypeResult.id;
                await this.dynamicConnection.query(`UPDATE staff_attendance SET 
            date = ?,
            staff_id = ?,
            staff_attendance_type_id = ?,
            remark = ?,
            updated_at = ?
            WHERE hospital_id = ? AND hos_staff_attendance_id = ?`, [
                    createStaffAttendance.date,
                    dynamicUPTDStaffId,
                    ADMINstaffAttendanceTypeID,
                    createStaffAttendance.remark,
                    formattedDate,
                    createStaffAttendance.hospital_id,
                    createStaffAttendance.id,
                ]);
                results.push({
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.STAFF_ATTENDANCE_UPDATE_MESSAGE,
                    Updated_Staff_attendance_details: updatedStaffAttendanceDetails,
                });
            }
            return results;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.NOT_FOUND,
                message: process.env.DATA_NOT_FOUND,
            }, common_1.HttpStatus.NOT_FOUND);
        }
    }
    async getStaffAttendanceList(filters) {
        const { role, date } = filters;
        let query = `
    SELECT 
    staff.employee_id AS StaffID,
    CONCAT(staff.name, ' ', staff.surname) AS StaffName,
    roles.name AS Role,
    staff_attendance_type.type
FROM staff_roles
LEFT JOIN staff ON staff.id = staff_roles.staff_id
LEFT JOIN staff_attendance ON staff.id = staff_attendance.staff_id 
LEFT JOIN staff_attendance_type ON staff_attendance_type.id = staff_attendance.staff_attendance_type_id
LEFT JOIN roles ON staff_roles.role_id = roles.id
    `;
        const values = [];
        const conditions = [];
        if (role) {
            conditions.push('roles.name = ?');
            values.push(role);
        }
        if (date) {
            conditions.push('staff_attendance.date = ?');
            values.push(date);
        }
        if (conditions.length > 0) {
            query += ' WHERE ' + conditions.join(' OR ');
        }
        else {
            return [];
        }
        const staffattendanceReport = await this.connection.query(query, values);
        return staffattendanceReport;
    }
    async StaffAttendanceListByRoleDate(date, roleId, search, limit, page) {
        const offset = (page - 1) * limit;
        let baseQuery = `
      SELECT 
  staff.employee_id AS StaffID,
  CONCAT(staff.name, ' ', staff.surname) AS StaffName,
  roles.name AS Role,
  staff_attendance_type.type,
  staff_attendance.date AS AttendanceDate
FROM staff_roles
INNER JOIN staff ON staff.id = staff_roles.staff_id
INNER JOIN roles ON staff_roles.role_id = roles.id
LEFT JOIN staff_attendance ON staff.id = staff_attendance.staff_id AND DATE(staff_attendance.date) = DATE(?)
LEFT JOIN staff_attendance_type ON staff_attendance_type.id = staff_attendance.staff_attendance_type_id
    `;
        let countQuery = `
      SELECT COUNT(DISTINCT staff.id) AS total
FROM staff_roles
INNER JOIN staff ON staff.id = staff_roles.staff_id
INNER JOIN roles ON staff_roles.role_id = roles.id
LEFT JOIN staff_attendance ON staff.id = staff_attendance.staff_id AND DATE(staff_attendance.date) = DATE(?)
LEFT JOIN staff_attendance_type ON staff_attendance_type.id = staff_attendance.staff_attendance_type_id
    `;
        const conditions = [];
        const values = [];
        conditions.push(`staff.is_active = 1`);
        if (roleId) {
            conditions.push(`roles.id = ?`);
            values.push(roleId);
        }
        if (search) {
            conditions.push(`
    (
      staff.employee_id LIKE ? OR 
      CONCAT(staff.name, ' ', staff.surname) LIKE ? OR 
      roles.name LIKE ? OR 
      staff_attendance_type.type LIKE ?
    )
  `);
            values.push(`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`);
        }
        if (date) {
            values.unshift(date);
        }
        const whereClause = conditions.length ? `WHERE ${conditions.join(' AND ')}` : '';
        const finalQuery = `${baseQuery} ${whereClause} GROUP BY staff.id ORDER BY StaffName ASC LIMIT ? OFFSET ?`;
        const finalValues = [...values, limit, offset];
        const finalCountQuery = `${countQuery} ${whereClause}`;
        const [details, totalResult] = await Promise.all([
            this.connection.query(finalQuery, finalValues),
            this.connection.query(finalCountQuery, values),
        ]);
        const total = totalResult[0]?.total || 0;
        return {
            details,
            total,
        };
    }
};
exports.StaffAttendanceService = StaffAttendanceService;
exports.StaffAttendanceService = StaffAttendanceService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], StaffAttendanceService);
//# sourceMappingURL=staff_attendance.service.js.map