"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaffAttendanceController = void 0;
const common_1 = require("@nestjs/common");
const staff_attendance_service_1 = require("./staff_attendance.service");
const auth_guard_1 = require("../auth/auth.guard");
let StaffAttendanceController = class StaffAttendanceController {
    constructor(staffAttendanceService) {
        this.staffAttendanceService = staffAttendanceService;
    }
    async create(createStaffAttendanceArray) {
        return this.staffAttendanceService.create(createStaffAttendanceArray);
    }
    async updateStaffAttendance(createStaffAttendanceArray) {
        const formattedStaffAttendanceArray = createStaffAttendanceArray.map((item) => ({
            ...item,
            date: item.date instanceof Date
                ? item.date.toISOString().split('T')[0]
                : item.date,
        }));
        const result = await this.staffAttendanceService.updateStaffAttendance(formattedStaffAttendanceArray);
        return {
            status: 'success',
            message: 'Staff attendance updated successfully',
            data: result,
        };
    }
    async getStaffAttendanceList(filters) {
        try {
            const getStaffAttendance = await this.staffAttendanceService.getStaffAttendanceList(filters);
            return getStaffAttendance;
        }
        catch (error) {
            console.error(error);
        }
    }
    async StaffAttendanceListByRoleDate(search, limit, page, date, role) {
        try {
            const attendanceDate = date ? new Date(date) : null;
            const limitNum = Number(limit) || 10;
            const pageNum = Number(page) || 1;
            const roleId = role || null;
            if (!attendanceDate || isNaN(attendanceDate.getTime())) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE,
                    status: process.env.ERROR_STATUS,
                    message: "Invalid or missing date provided.",
                };
            }
            const final_output = await this.staffAttendanceService.StaffAttendanceListByRoleDate(attendanceDate, roleId, search, limitNum, pageNum);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                };
            }
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: "No staff found for the provided filters.",
                data: [],
                total: 0,
            };
        }
        catch (error) {
            console.error('Error in get_staff_attendance_list_by_role_date:', error);
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.StaffAttendanceController = StaffAttendanceController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], StaffAttendanceController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], StaffAttendanceController.prototype, "updateStaffAttendance", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], StaffAttendanceController.prototype, "getStaffAttendanceList", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_attendance_list_by_role_date'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('date')),
    __param(4, (0, common_1.Query)('role')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, String, Number]),
    __metadata("design:returntype", Promise)
], StaffAttendanceController.prototype, "StaffAttendanceListByRoleDate", null);
exports.StaffAttendanceController = StaffAttendanceController = __decorate([
    (0, common_1.Controller)('staff-attendance'),
    __metadata("design:paramtypes", [staff_attendance_service_1.StaffAttendanceService])
], StaffAttendanceController);
//# sourceMappingURL=staff_attendance.controller.js.map