"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPharmacySupplierService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupPharmacySupplierService = class SetupPharmacySupplierService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(supplierEntity) {
        try {
            const result = await this.connection.query('INSERT INTO medicine_supplier (supplier,contact,supplier_person,supplier_person_contact,supplier_drug_licence,address) VALUES (?,?,?,?,?,?)', [
                supplierEntity.supplier,
                supplierEntity.contact,
                supplierEntity.supplier_person,
                supplierEntity.supplier_person_contact,
                supplierEntity.supplier_drug_licence,
                supplierEntity.address,
            ]);
            await this.dynamicConnection.query('INSERT INTO medicine_supplier (supplier,contact,supplier_person,supplier_person_contact,supplier_drug_licence,address,Hospital_id,hospital_medicine_supplier_id) values (?,?,?,?,?,?,?,?)', [
                supplierEntity.supplier,
                supplierEntity.contact,
                supplierEntity.supplier_person,
                supplierEntity.supplier_person_contact,
                supplierEntity.supplier_drug_licence,
                supplierEntity.address,
                supplierEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: 'success',
                        messege: 'medicine_supplier details added successfully ',
                        inserted_data: await this.connection.query('SELECT * FROM medicine_supplier WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const supplier = await this.connection.query('SELECT * FROM medicine_supplier');
            return supplier;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVER IS TEMPORARILY UNAVAILABLE.PLEASE TRY AGAIN LATER`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM medicine_supplier WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const supplier = await this.connection.query('SELECT * FROM medicine_supplier WHERE id = ?', [id]);
            return supplier;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVER IS TEMPORARILY UNAVAILABLE.PLEASE TRY AGAIN LATER`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, supplierEntity) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM medicine_supplier WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE medicine_supplier SET supplier =?,contact =?,supplier_person =?,supplier_person_contact =?,supplier_drug_licence =?,address =? WHERE id = ?', [
                supplierEntity.supplier,
                supplierEntity.contact,
                supplierEntity.supplier_person,
                supplierEntity.supplier_person_contact,
                supplierEntity.supplier_drug_licence,
                supplierEntity.address,
                id,
            ]);
            await this.dynamicConnection.query('update medicine_supplier SET supplier =?,contact =?,supplier_person =?,supplier_person_contact =?,supplier_drug_licence =?,address =? where hospital_medicine_supplier_id =? and Hospital_id =?', [
                supplierEntity.supplier,
                supplierEntity.contact,
                supplierEntity.supplier_person,
                supplierEntity.supplier_person_contact,
                supplierEntity.supplier_drug_licence,
                supplierEntity.address,
                id,
                supplierEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: 'success',
                        message: 'supplier details updated successfully ',
                        updated_values: await this.connection.query('SELECT * FROM medicine_supplier WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVER IS TEMPORARILY UNAVAILABLE.PLEASE TRY AGAIN LATER`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM medicine_supplier WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM medicine_supplier WHERE id = ?', [id]);
            const [adminresult] = await this.dynamicConnection.query(`select id from medicine_supplier where hospital_medicine_supplier_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from medicine_supplier where id = ? and Hospital_id = ?`, [adminresult.id, Hospital_id]);
            return [
                {
                    status: 'success',
                    message: ' id: ' + id + ' deleted successfully',
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVER IS TEMPORARILY UNAVAILABLE.PLEASE TRY AGAIN LATER`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findallpharmacy_supplier(limit, page) {
        try {
            const offset = limit * (page - 1);
            const suppliers = await this.connection.query(`SELECT * FROM medicine_supplier LIMIT ? OFFSET ? `, [
                Number(limit), Number(offset)
            ]);
            let [totallist] = await this.connection.query(`select count(id) as total from medicine_supplier`);
            let variables = {
                details: suppliers,
                total: totallist.total,
                page: page,
                limit: limit,
            };
            return variables;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVER IS TEMPORARILY UNAVAILABLE.PLEASE TRY AGAIN LATER`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupPharmacySupplierService = SetupPharmacySupplierService;
exports.SetupPharmacySupplierService = SetupPharmacySupplierService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupPharmacySupplierService);
//# sourceMappingURL=setup_pharmacy_supplier.service.js.map