"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MedicineCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let MedicineCategoryService = class MedicineCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(MedicineCategoryEntity) {
        try {
            const result = await this.connection.query('INSERT INTO medicine_category (medicine_category) VALUES (?)', [MedicineCategoryEntity.medicine_category]);
            await this.dynamicConnection.query(`INSERT INTO medicine_category (medicine_category,Hospital_id,hospital_medicine_category_id) values (?,?,?)`, [
                MedicineCategoryEntity.medicine_category,
                MedicineCategoryEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: 'success',
                        messege: 'medicine_category details added successfully inserted',
                        inserted_data: await this.connection.query('SELECT * FROM medicine_category WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const medicine_category = await this.connection.query('SELECT * FROM medicine_category');
            return medicine_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.dynamicConnection.query(`
      SELECT * FROM medicine_category WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const medicine_category = await this.connection.query('SELECT * FROM medicine_category WHERE id = ?', [id]);
            return medicine_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, MedicineCategoryEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM medicine_category WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: 'error', message: `ID ${id} does not exist or It has been already deleted` }];
        }
        try {
            await this.connection.query('UPDATE medicine_category SET medicine_category =? WHERE id = ?', [MedicineCategoryEntity.medicine_category, id]);
            await this.dynamicConnection.query('update medicine_category SET medicine_category = ? where hospital_medicine_category_id =? and Hospital_id = ?', [
                MedicineCategoryEntity.medicine_category,
                id,
                MedicineCategoryEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: 'success',
                        messege: 'medicine_category details updated successfully inserted',
                        updated_values: await this.connection.query('SELECT * FROM medicine_category WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM medicine_category WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: 'error', message: `ID ${id} does not exist or It has been already deleted` }];
        }
        try {
            await this.connection.query('DELETE FROM medicine_category WHERE id = ?', [id]);
            const [medicine_category] = await this.dynamicConnection.query(`select id from medicine_category where hospital_medicine_category_id = ? `, [id]);
            await this.dynamicConnection.query(`delete from medicine_category where id = ? and Hospital_id = ?`, [medicine_category.id, Hospital_id]);
            return [
                {
                    status: 'success',
                    message: ' id: ' + id + ' deleted successfully',
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupPharmacyMedicineCategory(search) {
        let query = ` SELECT * FROM medicine_category `;
        let values = [];
        if (search) {
            query += ` WHERE ( medicine_category.medicine_category LIKE ? ) `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupPharmacyMedicineCategorySearch = await this.connection.query(final, values);
        return setupPharmacyMedicineCategorySearch;
    }
    async findmedicine_category(limit, page) {
        try {
            const offset = limit * (page - 1);
            const medicine_category = await this.connection.query(`SELECT * FROM medicine_category LIMIT ? OFFSET ?`, [
                Number(limit), Number(offset)
            ]);
            let [totallist] = await this.connection.query(`select count(id) as total from medicine_category`);
            let variables = {
                details: medicine_category,
                total: totallist.total,
                page: page,
                limit: limit
            };
            return variables;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.MedicineCategoryService = MedicineCategoryService;
exports.MedicineCategoryService = MedicineCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], MedicineCategoryService);
//# sourceMappingURL=setup_pharmacy_medicine_category.service.js.map