"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MedicineCategoryController = void 0;
const common_1 = require("@nestjs/common");
const setup_pharmacy_medicine_category_service_1 = require("./setup_pharmacy_medicine_category.service");
const setup_pharmacy_medicine_category_entity_1 = require("./entities/setup_pharmacy_medicine_category.entity");
const auth_guard_1 = require("../auth/auth.guard");
let MedicineCategoryController = class MedicineCategoryController {
    constructor(medicineCategoryService) {
        this.medicineCategoryService = medicineCategoryService;
    }
    create(medicine_categoryEntity) {
        return this.medicineCategoryService.create(medicine_categoryEntity);
    }
    findAll() {
        return this.medicineCategoryService.findAll();
    }
    findOne(id) {
        return this.medicineCategoryService.findOne(id);
    }
    update(id, medicine_categoryEntity) {
        return this.medicineCategoryService.update(id, medicine_categoryEntity);
    }
    async remove(id, Hospital_id) {
        return this.medicineCategoryService.remove(id, Hospital_id);
    }
    setupPharmacyMedicineCategory(search) {
        return this.medicineCategoryService.setupPharmacyMedicineCategory(search);
    }
    async getallmedicine_category(limit, page) {
        try {
            let final_output = await this.medicineCategoryService.findmedicine_category(limit || 10, page || 1);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit)
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.MedicineCategoryController = MedicineCategoryController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_pharmacy_medicine_category_entity_1.SetupPharmacyMedicineCategory]),
    __metadata("design:returntype", void 0)
], MedicineCategoryController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MedicineCategoryController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MedicineCategoryController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_pharmacy_medicine_category_entity_1.SetupPharmacyMedicineCategory]),
    __metadata("design:returntype", void 0)
], MedicineCategoryController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], MedicineCategoryController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/setupPharmacyMedicineCategory/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MedicineCategoryController.prototype, "setupPharmacyMedicineCategory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllmedicine_category'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], MedicineCategoryController.prototype, "getallmedicine_category", null);
exports.MedicineCategoryController = MedicineCategoryController = __decorate([
    (0, common_1.Controller)('setup_pharmacy_medicine_category'),
    __metadata("design:paramtypes", [setup_pharmacy_medicine_category_service_1.MedicineCategoryService])
], MedicineCategoryController);
//# sourceMappingURL=setup_pharmacy_medicine_category.controller.js.map