"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPharmacyDoseDurationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupPharmacyDoseDurationService = class SetupPharmacyDoseDurationService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(dose_durationEntity) {
        try {
            const result = await this.connection.query('INSERT INTO dose_duration (name) VALUES (?)', [dose_durationEntity.name]);
            await this.dynamicConnection.query('INSERT INTO dose_duration (name,Hospital_id,hospital_dose_duration_id) VALUES (?,?,?)', [
                dose_durationEntity.name,
                dose_durationEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: 'success',
                        messege: 'dose_duration details added successfully ',
                        inserted_data: await this.connection.query('SELECT * FROM dose_duration WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const dose_duration = await this.connection.query('SELECT * FROM dose_duration');
            return dose_duration;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_duration WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const dose_duration = await this.connection.query('SELECT * FROM dose_duration WHERE id = ?', [id]);
            return dose_duration;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, dose_durationEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_duration WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE dose_duration SET name =? WHERE id = ?', [dose_durationEntity.name, id]);
            await this.dynamicConnection.query('update dose_duration SET name = ? where hospital_dose_duration_id = ? and Hospital_id = ?', [dose_durationEntity.name, id, dose_durationEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: 'success',
                        messege: 'dose_duration details updated successfully ',
                        updated_values: await this.connection.query('SELECT * FROM dose_duration WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_duration WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: 'error', message: `ID ${id} does not exist or It has been already deleted` }];
        }
        try {
            await this.connection.query('DELETE FROM dose_duration WHERE id = ?', [id]);
            const [dose_duration] = await this.dynamicConnection.query(`select id from dose_duration where hospital_dose_duration_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from dose_duration where id = ? and Hospital_id = ?`, [dose_duration.id, Hospital_id]);
            return [
                {
                    status: 'success',
                    message: ' id: ' + id + ' deleted successfully',
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupPharmacyDoseDuration(search) {
        let query = ` SELECT * FROM dose_duration `;
        let values = [];
        if (search) {
            query += ` WHERE ( dose_duration.name LIKE ? ) `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupPharmacyDoseDurationSearch = await this.connection.query(final, values);
        return setupPharmacyDoseDurationSearch;
    }
    async findALLdose_duration(limit, page) {
        try {
            const offset = limit * (page - 1);
            const dose_durations = await this.connection.query(`SELECT * FROM dose_duration LIMIT ? OFFSET ?`, [
                Number(limit), Number(offset)
            ]);
            let [totallist] = await this.connection.query(`select count(id) as total from dose_duration`);
            let variable = {
                details: dose_durations,
                total: totallist.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupPharmacyDoseDurationService = SetupPharmacyDoseDurationService;
exports.SetupPharmacyDoseDurationService = SetupPharmacyDoseDurationService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupPharmacyDoseDurationService);
//# sourceMappingURL=setup_pharmacy_dose_duration.service.js.map