"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unit_typecontroller = void 0;
const common_1 = require("@nestjs/common");
const setup_hospital_charges_unit_type_service_1 = require("./setup_hospital_charges_unit_type.service");
const setup_hospital_charges_unit_type_entity_1 = require("./entities/setup_hospital_charges_unit_type.entity");
const auth_guard_1 = require("../auth/auth.guard");
let unit_typecontroller = class unit_typecontroller {
    constructor(unit_typeService) {
        this.unit_typeService = unit_typeService;
    }
    create(unit_typeEntity) {
        return this.unit_typeService.create(unit_typeEntity);
    }
    findALL() {
        return this.unit_typeService.findAll();
    }
    findOne(id) {
        return this.unit_typeService.findOne(id);
    }
    update(id, unit_typeEntity) {
        return this.unit_typeService.update(id, unit_typeEntity);
    }
    async remove(id, Hospital_id) {
        const deleteunit_type = await this.unit_typeService.remove(id, Hospital_id);
        return deleteunit_type;
    }
    setupHosChargesUnitType(search) {
        return this.unit_typeService.setupHosChargesUnitType(search);
    }
    async findallunittype(limit, page, search) {
        try {
            let final_output = await this.unit_typeService.findALLunit_type(limit || 10, page || 1, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.unit_typecontroller = unit_typecontroller;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_hospital_charges_unit_type_entity_1.SetupHospitalChargesUnitType]),
    __metadata("design:returntype", void 0)
], unit_typecontroller.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], unit_typecontroller.prototype, "findALL", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], unit_typecontroller.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_hospital_charges_unit_type_entity_1.SetupHospitalChargesUnitType]),
    __metadata("design:returntype", void 0)
], unit_typecontroller.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], unit_typecontroller.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupHospitalChargesUnitType/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], unit_typecontroller.prototype, "setupHosChargesUnitType", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getALLunittype'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], unit_typecontroller.prototype, "findallunittype", null);
exports.unit_typecontroller = unit_typecontroller = __decorate([
    (0, common_1.Controller)('setup-hospital-charges-unit-type'),
    __metadata("design:paramtypes", [setup_hospital_charges_unit_type_service_1.unit_typeService])
], unit_typecontroller);
//# sourceMappingURL=setup_hospital_charges_unit_type.controller.js.map