"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHospitalChargesChargeCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupHospitalChargesChargeCategoryService = class SetupHospitalChargesChargeCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(charge_categoryEntity) {
        try {
            const result = await this.connection.query('INSERT INTO charge_categories (charge_type_id,name,description,is_default) VALUES (?,?,?,?)', [
                charge_categoryEntity.charge_type_id,
                charge_categoryEntity.name,
                charge_categoryEntity.description,
                charge_categoryEntity.is_default,
            ]);
            const [charge_category] = await this.dynamicConnection.query(`select id from charge_type_master where Hospital_id = ?
   and hospital_charge_type_master_id = ?`, [
                charge_categoryEntity.Hospital_id,
                charge_categoryEntity.charge_type_id,
            ]);
            await this.dynamicConnection.query(`INSERT INTO charge_categories (charge_type_id,name,description,short_code,is_default,Hospital_id,hospital_charge_categories_id) values (?,?,?,?,?,?,?)`, [
                charge_category.id,
                charge_categoryEntity.name,
                charge_categoryEntity.description,
                charge_categoryEntity.short_code,
                charge_categoryEntity.is_default,
                charge_categoryEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    data: {
                        'id ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.CHARGE_CATEGORY_ADDED,
                        inserted_data: await this.connection.query('SELECT * FROM charge_categories WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const charge_category = await this.connection
                .query(`select charge_categories.id,charge_type_master.charge_type,charge_categories.charge_type_id,charge_categories.name,charge_categories.description,charge_categories.short_code,charge_categories.is_default,
  charge_categories.created_at from charge_categories
  join charge_type_master ON charge_categories.charge_type_id = charge_type_master.id;`);
            return charge_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_categories WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charge_category = await this.connection.query('SELECT * FROM charge_categories WHERE id = ?', [id]);
            return charge_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, charge_categoryEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_categories WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE charge_categories SET charge_type_id =?,name =?,description =?  WHERE id = ?', [
                charge_categoryEntity.charge_type_id,
                charge_categoryEntity.name,
                charge_categoryEntity.description,
                id,
            ]);
            const [charge_type] = await this.dynamicConnection.query(`select charge_type_id from charge_categories where hospital_charge_categories_id = ? and Hospital_id = ? `, [id, charge_categoryEntity.Hospital_id]);
            await this.dynamicConnection.query('update charge_categories SET  charge_type_id =?,name =?,description =? where hospital_charge_categories_id = ? and Hospital_id = ?', [
                charge_type.charge_type_id,
                charge_categoryEntity.name,
                charge_categoryEntity.description,
                id,
                charge_categoryEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.CHARGE_CATEGORY_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM charge_categories WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_categories WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM charge_categories WHERE id = ?', [id]);
            const charge_cate = await this.dynamicConnection.query(`select id from charge_categories where hospital_charge_categories_id = ?`, [id]);
            const charge_category = charge_cate[0].id;
            await this.dynamicConnection.query(`delete from charge_categories where id = ? and Hospital_id = ?`, [charge_category, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            if (error.code === 'ER_ROW_IS_REFERENCED_2' ||
                error.errno === 1451) {
                return [
                    {
                        status: process.env.ERROR,
                        message: `Cannot delete ID ${id} because it is in use (foreign key constraint).`,
                    },
                ];
            }
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async HospitalChargesChargeCategory(search) {
        let query = ` select charge_categories.id,charge_type_master.charge_type,charge_categories.charge_type_id,charge_categories.name,charge_categories.description,charge_categories.short_code,charge_categories.is_default,
  charge_categories.created_at from charge_categories
  join charge_type_master ON charge_categories.charge_type_id = charge_type_master.id `;
        let values = [];
        if (search) {
            query += ` WHERE ( charge_categories.name LIKE ? OR charge_type_master.charge_type LIKE ? OR charge_categories.description LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupHospitalChargesChargeCategorySearch = await this.connection.query(final, values);
        return setupHospitalChargesChargeCategorySearch;
    }
    async find_charge_category(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let dateCondition = '';
            let searchClause = '';
            if (search) {
                const searchClause = `(
        charge_categories.name LIKE '%${search}%' OR
        charge_type_master.charge_type LIKE '%${search}%' OR
        charge_categories.description LIKE '%${search}%'
        )`;
                dateCondition += ` AND ${searchClause}`;
            }
            const charge_category = await this.connection.query(`select charge_categories.id,
        charge_type_master.charge_type,charge_categories.charge_type_id,
        charge_categories.name,charge_categories.description,charge_categories.short_code,
        charge_categories.is_default,charge_categories.created_at 
        from charge_categories
        join charge_type_master ON charge_categories.charge_type_id = charge_type_master.id ${dateCondition} LIMIT ? OFFSET ?`, [Number(limit), Number(offset)]);
            let [totallist] = await this.connection.query(`select count(id) as total FROM charge_categories`);
            let variable = {
                details: charge_category,
                total: totallist.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupHospitalChargesChargeCategoryService = SetupHospitalChargesChargeCategoryService;
exports.SetupHospitalChargesChargeCategoryService = SetupHospitalChargesChargeCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupHospitalChargesChargeCategoryService);
//# sourceMappingURL=setup_hospital_charges_charge_category.service.js.map