"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupHospitalChargesChargeCategoryController = void 0;
const common_1 = require("@nestjs/common");
const setup_hospital_charges_charge_category_service_1 = require("./setup_hospital_charges_charge_category.service");
const setup_hospital_charges_charge_category_entity_1 = require("./entities/setup_hospital_charges_charge_category.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupHospitalChargesChargeCategoryController = class SetupHospitalChargesChargeCategoryController {
    constructor(setupHospitalChargesChargeCategoryService) {
        this.setupHospitalChargesChargeCategoryService = setupHospitalChargesChargeCategoryService;
    }
    create(charge_categoryEntity) {
        return this.setupHospitalChargesChargeCategoryService.create(charge_categoryEntity);
    }
    findAll() {
        return this.setupHospitalChargesChargeCategoryService.findAll();
    }
    findOne(id) {
        return this.setupHospitalChargesChargeCategoryService.findOne(id);
    }
    update(id, charge_categoryEntity) {
        return this.setupHospitalChargesChargeCategoryService.update(id, charge_categoryEntity);
    }
    remove(id, Hospital_id) {
        return this.setupHospitalChargesChargeCategoryService.remove(id, Hospital_id);
    }
    HospitalChargesChargeCategory(search) {
        return this.setupHospitalChargesChargeCategoryService.HospitalChargesChargeCategory(search);
    }
    async findallcategory(limit, page, search) {
        try {
            let final_output = await this.setupHospitalChargesChargeCategoryService.find_charge_category(limit || 10, page || 1, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / limit)
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No charge_category found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupHospitalChargesChargeCategoryController = SetupHospitalChargesChargeCategoryController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_hospital_charges_charge_category_entity_1.SetupHospitalChargesChargeCategory]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_hospital_charges_charge_category_entity_1.SetupHospitalChargesChargeCategory]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupHospitalChargesChargeCategory/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupHospitalChargesChargeCategoryController.prototype, "HospitalChargesChargeCategory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllcharge_category'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], SetupHospitalChargesChargeCategoryController.prototype, "findallcategory", null);
exports.SetupHospitalChargesChargeCategoryController = SetupHospitalChargesChargeCategoryController = __decorate([
    (0, common_1.Controller)('setup-hospital-charges-charge-category'),
    __metadata("design:paramtypes", [setup_hospital_charges_charge_category_service_1.SetupHospitalChargesChargeCategoryService])
], SetupHospitalChargesChargeCategoryController);
//# sourceMappingURL=setup_hospital_charges_charge_category.controller.js.map