"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFrontOfficeSourceService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupFrontOfficeSourceService = class SetupFrontOfficeSourceService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(sourceEntity) {
        try {
            const result = await this.connection.query('INSERT INTO source (source,description) VALUES (?,?)', [sourceEntity.source, sourceEntity.description]);
            await this.dynamicConnection.query(`INSERT INTO source (source,description,Hospital_id,hospital_source_id) values(?,?,?,?)`, [
                sourceEntity.source,
                sourceEntity.description,
                sourceEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SOURCE_ADDED,
                        inserted_data: await this.connection.query('SELECT * FROM source WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const source = await this.connection.query('SELECT * FROM source');
            return source;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM source WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const source = await this.connection.query('SELECT * FROM source WHERE id = ?', [id]);
            if (source.length === 1) {
                return source;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, sourceEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM source WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE source SET source =?, description = ? WHERE id = ?', [sourceEntity.source, sourceEntity.description, id]);
            await this.dynamicConnection.query('update source SET  source =?, description = ? where hospital_source_id = ? and Hospital_id = ? ', [
                sourceEntity.source,
                sourceEntity.description,
                id,
                sourceEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SOURCE_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM source WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM source WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            const result = await this.connection.query('DELETE FROM source WHERE id = ?', [id]);
            const [source] = await this.dynamicConnection.query(`select id from source where hospital_source_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from source where id = ? and Hospital_id = ?`, [source.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupFrontofficeSource(search) {
        let query = ` SELECT * FROM source `;
        let values = [];
        if (search) {
            query += ` WHERE ( source.source LIKE ? OR source.description LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupFrontOfficeSource = await this.connection.query(final, values);
        return setupFrontOfficeSource;
    }
    async finadallsource(limit, pagenumber) {
        try {
            if (!limit) {
                limit = 10;
            }
            if (!pagenumber) {
                pagenumber = 1;
            }
            const offset = limit * (pagenumber - 1);
            const source = await this.connection.query('SELECT * FROM source LIMIT ? OFFSET ?', [Number(limit), Number(offset)]);
            let [total_list] = await this.connection.query(`SELECT count(id) as total from source `);
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.SOURCE_FETCHED,
                data: source,
                total: total_list.total
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupFrontOfficeSourceService = SetupFrontOfficeSourceService;
exports.SetupFrontOfficeSourceService = SetupFrontOfficeSourceService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupFrontOfficeSourceService);
//# sourceMappingURL=setup_front_office_source.service.js.map