"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFrontOfficePurposeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupFrontOfficePurposeService = class SetupFrontOfficePurposeService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(purposeEntity) {
        try {
            const result = await this.connection.query('INSERT INTO visitors_purpose (visitors_purpose,description) VALUES (?,?)', [purposeEntity.visitors_purpose, purposeEntity.description]);
            await this.dynamicConnection.query(`INSERT INTO visitors_purpose (visitors_purpose,description,Hospital_id,hospital_visitors_purpose_id) VALUES (?,?,?,?)`, [
                purposeEntity.visitors_purpose,
                purposeEntity.description,
                purposeEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.PURPOSE_ADDED,
                        inserted_data: await this.connection.query('SELECT * FROM visitors_purpose WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const purpose = await this.connection.query('SELECT * FROM visitors_purpose');
            return purpose;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM visitors_purpose WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const purpose = await this.connection.query('SELECT * FROM visitors_purpose WHERE id = ?', [id]);
            return purpose;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, purposeEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM visitors_purpose WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE visitors_purpose SET visitors_purpose =?, description = ? WHERE id = ?', [purposeEntity.visitors_purpose, purposeEntity.description, id]);
            await this.dynamicConnection.query('update visitors_purpose SET visitors_purpose =?, description = ? where hospital_visitors_purpose_id = ?  and Hospital_id = ? ', [
                purposeEntity.visitors_purpose,
                purposeEntity.description,
                id,
                purposeEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.VISITOR_PURPOSE,
                        updated_values: await this.connection.query('SELECT * FROM visitors_purpose WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM visitors_purpose WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM visitors_purpose WHERE id = ?', [id]);
            const [front_office_purpose] = await this.dynamicConnection.query(`select id from visitors_purpose where hospital_visitors_purpose_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from visitors_purpose where id = ? and Hospital_id = ?`, [front_office_purpose.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async SetupFrontOfficePurpose(search) {
        let query = ` SELECT * FROM visitors_purpose `;
        let values = [];
        if (search) {
            query += ` WHERE ( visitors_purpose.visitors_purpose LIKE ? OR visitors_purpose.description LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupFrontOfficePurpose = await this.connection.query(final, values);
        return setupFrontOfficePurpose;
    }
    async findALLPURPOSE(limit, pagenumber) {
        try {
            if (!limit) {
                limit = 10;
            }
            if (!pagenumber) {
                pagenumber = 1;
            }
            const offset = limit * (pagenumber - 1);
            const front_office_purpose = await this.connection.query(`select * FROM visitors_purpose LIMIT ? OFFSET ?`, [Number(limit), Number(offset)]);
            let [total_list] = await this.connection.query(`select count(id) as total from visitors_purpose`);
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.VISITOR_PURPOSE_FETCHED,
                data: front_office_purpose,
                total: total_list.total
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupFrontOfficePurposeService = SetupFrontOfficePurposeService;
exports.SetupFrontOfficePurposeService = SetupFrontOfficePurposeService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupFrontOfficePurposeService);
//# sourceMappingURL=setup_front_office_purpose.service.js.map