"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFrontOfficeComplainTypeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupFrontOfficeComplainTypeService = class SetupFrontOfficeComplainTypeService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(complain_typeEntity) {
        try {
            const result = await this.connection.query('INSERT INTO complaint_type (complaint_type,description) VALUES (?,?)', [complain_typeEntity.complaint_type, complain_typeEntity.description]);
            await this.dynamicConnection.query('INSERT INTO complaint_type (complaint_type,description,Hospital_id,hospital_complaint_type_id) VALUES (?,?,?,?)', [
                complain_typeEntity.complaint_type,
                complain_typeEntity.description,
                complain_typeEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.COMPLAINT_TYPE,
                        inserted_data: await this.connection.query('SELECT * FROM complaint_type WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const complaint_type = await this.connection.query('SELECT * FROM complaint_type');
            return complaint_type;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM complaint_type WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const complaint_type = await this.connection.query('SELECT * FROM complaint_type WHERE id = ?', [id]);
            return complaint_type;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, complain_typeEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM complaint_type WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE complaint_type SET complaint_type =?, description = ? WHERE id = ?', [
                complain_typeEntity.complaint_type,
                complain_typeEntity.description,
                id,
            ]);
            await this.dynamicConnection.query('update complaint_type SET complaint_type =?, description = ? where hospital_complaint_type_id = ? and Hospital_id = ? ', [
                complain_typeEntity.complaint_type,
                complain_typeEntity.description,
                id,
                complain_typeEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.COMPLAINT_TYPE_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM complaint_type WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM complaint_type WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR, message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM complaint_type WHERE id = ?', [id]);
            const [complain_type] = await this.dynamicConnection.query(`select id from complaint_type where hospital_complaint_type_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from complaint_type where id = ? and Hospital_id = ?`, [complain_type.id, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async SetupFrontofficeComplainType(search) {
        let query = ` SELECT * FROM complaint_type `;
        let values = [];
        if (search) {
            query += ` WHERE ( complaint_type.complaint_type LIKE ? OR complaint_type.description LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const SetupFrontOfficeComplainType = await this.connection.query(final, values);
        return SetupFrontOfficeComplainType;
    }
    async find_complaintype(limit, pagenumber) {
        try {
            if (!limit) {
                limit = 10;
            }
            if (!pagenumber) {
                pagenumber = 1;
            }
            const offset = limit * (pagenumber - 1);
            const complaint_type = await this.connection.query('SELECT * FROM complaint_type LIMIT ? OFFSET ?', [Number(limit), Number(offset)]);
            let [total_list] = await this.connection.query(`SELECT count(id) as total from complaint_type`);
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.COMPLAINT_TYPE_FETCHED,
                data: process.env.COMPLAINT_TYPE_DATA,
                total: total_list.total
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupFrontOfficeComplainTypeService = SetupFrontOfficeComplainTypeService;
exports.SetupFrontOfficeComplainTypeService = SetupFrontOfficeComplainTypeService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupFrontOfficeComplainTypeService);
//# sourceMappingURL=setup_front_office_complain_type.service.js.map