"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupFrontOfficeAppointmentPriorityService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SetupFrontOfficeAppointmentPriorityService = class SetupFrontOfficeAppointmentPriorityService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(appointment_priority) {
        try {
            const result = await this.connection.query('INSERT INTO appoint_priority (priority_status) VALUES (?)', [appointment_priority.priority_status]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.APPOINTMENT_PRIORITY,
                        inserted_data: await this.connection.query('SELECT * FROM appoint_priority WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const appoint_priority = await this.connection.query('select id,priority_status from appoint_priority');
            return appoint_priority;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM charge_categories WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const appoint_priority = await this.connection.query('select id,priority_status from appoint_priority where id = ?', [id]);
            return appoint_priority;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, appoint_priorityEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM appoint_priority WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('update appoint_priority SET priority_status = ? where id = ?', [appoint_priorityEntity.priority_status, id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.APPOINTMENT_PRIORITY_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM appoint_priority WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id) {
        try {
            const [existingRecord] = await this.connection.query('SELECT id FROM appoint_priority WHERE id = ?', [id]);
            if (!existingRecord) {
                return [{ status: process.env.ERROR,
                        message: process.env.EXISTING_RECORD }];
            }
            await this.connection.query('DELETE FROM appoint_priority WHERE id = ?', [id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupFrontofficeAppointPriority(search) {
        let query = ` SELECT * FROM appoint_priority `;
        let values = [];
        if (search) {
            query += ` WHERE ( appoint_priority.priority_status LIKE ? )  `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupAppointPrioritySearch = await this.connection.query(final, values);
        return setupAppointPrioritySearch;
    }
};
exports.SetupFrontOfficeAppointmentPriorityService = SetupFrontOfficeAppointmentPriorityService;
exports.SetupFrontOfficeAppointmentPriorityService = SetupFrontOfficeAppointmentPriorityService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SetupFrontOfficeAppointmentPriorityService);
//# sourceMappingURL=setup_front_office_appointment_priority.service.js.map