"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupApptSlotAmountService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupApptSlotAmountService = class SetupApptSlotAmountService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(slotEntity) {
        try {
            const [check] = await this.connection.query('select id from shift_details where staff_id = ?', [slotEntity.staff_id]);
            const [getStaffMail] = await this.connection.query(`select email from staff where id = ?`, [slotEntity.staff_id]);
            const [getAdminStaff] = await this.dynamicConnection.query(`select id from staff where email = ?`, [getStaffMail.email]);
            const [getAdminChargeId] = await this.dynamicConnection.query(`select id from charges 
where Hospital_id = ? and hospital_charges_id = ? `, [slotEntity.Hospital_id, slotEntity.charge_id]);
            if (check) {
                await this.connection.query(`
    update shift_details set 
    consult_duration = ? ,charge_id = ?
     where id = ? `, [slotEntity.consult_duration, slotEntity.charge_id, check.id]);
                const [getAdminShift] = await this.dynamicConnection.query(`select id from shift_details
     where Hospital_id = ? and hospital_shift_details_id = ?`, [slotEntity.Hospital_id, check.id]);
                const updateQuery = `
  update shift_details
  set consult_duration = ?,
      charge_id = ?
  where id = ?
`;
                await this.dynamicConnection.query(updateQuery, [slotEntity.consult_duration, getAdminChargeId.id, getAdminShift.id]);
                return [
                    {
                        data: {
                            status: process.env.SUCCESS_STATUS_V2,
                            messege: process.env.SHIFT_DETAILS_UPDATED,
                        },
                    },
                ];
            }
            else {
                const insert = await this.connection.query(`insert into shift_details(staff_id,
    consult_duration,
    charge_id
    ) values (?,?,?)`, [
                    slotEntity.staff_id,
                    slotEntity.consult_duration,
                    slotEntity.charge_id,
                ]);
                await this.dynamicConnection.query(`insert into shift_details(staff_id,
    consult_duration,
    charge_id,Hospital_id,hospital_shift_details_id) values (?,?,?,?,?)`, [
                    getAdminStaff.id,
                    slotEntity.consult_duration,
                    getAdminChargeId.id,
                    slotEntity.Hospital_id,
                    insert.insertId,
                ]);
                return [
                    {
                        data: {
                            id: insert.insertId,
                            status: process.env.SUCCESS_STATUS_V2,
                            messege: process.env.SHIFT_DETAILS,
                            inserted_data: await this.connection.query('SELECT * FROM shift_details WHERE id = ?', [insert.insertId]),
                        },
                    },
                ];
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findforDocAndGlobalShift(staff_id) {
        try {
            const getCharge = await this.connection.query(`select shift_details.id, shift_details.consult_duration,charges.name charge_name,
    charges.charge_category_id,charges.id as charge_id,charges.standard_charge,round((charges.standard_charge+
      (charges.standard_charge*((tax_category.percentage)/100))),2) amount,charge_categories.name charge_category_name
     from shift_details left join charges on charges.id = shift_details.charge_id
     left join charge_categories on charge_categories.id = charges.charge_category_id 
     left join tax_category on charges.tax_category_id = tax_category.id where shift_details.staff_id = ?`, [staff_id]);
            return getCharge;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, slotEntity) {
        try {
            const [existingRecord] = await this.connection.query('SELECT id FROM shift_details WHERE id = ?', [id]);
            if (!existingRecord) {
                return [{ status: process.env.ERROR,
                        message: process.env.EXISTING_RECORD }];
            }
            await this.connection.query(`update shift_details set consult_duration = ? ,charge_id = ? where id = ?`, [slotEntity.consult_duration, slotEntity.charge_id, id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SHIFT_DETAILS_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM shift_details WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM shift_details WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('delete from shift_details where id = ?', [id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED,
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupApptSlotAmountService = SetupApptSlotAmountService;
exports.SetupApptSlotAmountService = SetupApptSlotAmountService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupApptSlotAmountService);
//# sourceMappingURL=setup_appt_slot_amount.service.js.map