"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupSymptomsSymptomsTypeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupSymptomsSymptomsTypeService = class SetupSymptomsSymptomsTypeService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(symptoms_typeEntity) {
        try {
            const result = await this.connection.query('INSERT INTO symptoms_classification (symptoms_type) VALUES (?)', [symptoms_typeEntity.symptoms_type]);
            await this.dynamicConnection.query(`insert into symptoms_classification (symptoms_type,Hospital_id,hospital_symptoms_classification_id) values (?,?,?)`, [
                symptoms_typeEntity.symptoms_type,
                symptoms_typeEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.SYMPTOMS_CLASSIFICATION,
                        inserted_data: await this.connection.query('SELECT * FROM symptoms_classification WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const symptoms_classification = await this.connection.query('SELECT * FROM symptoms_classification');
            return symptoms_classification;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const symptoms_classification = await this.connection.query('SELECT * FROM symptoms_classification WHERE id = ?', [id]);
            if (symptoms_classification.length === 1) {
                return symptoms_classification;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, symptoms_typeEntity) {
        try {
            await this.connection.query('UPDATE symptoms_classification SET symptoms_type =? WHERE id = ?', [symptoms_typeEntity.symptoms_type, id]);
            await this.dynamicConnection.query('update symptoms_classification SET symptoms_type = ? where hospital_symptoms_classification_id = ? and Hospital_id= ?', [
                symptoms_typeEntity.symptoms_type,
                id,
                symptoms_typeEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SYMPTOMS_CLASSIFICATION_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM symptoms_classification WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM symptoms_classification WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from symptoms_classification where hospital_symptoms_classification_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from symptoms_classification where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [
            {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            },
        ];
    }
    async setupSymptomsType(search) {
        try {
            let query = ` SELECT * FROM symptoms_classification `;
            let values = [];
            if (search) {
                query += ` WHERE ( symptoms_classification.symptoms_type LIKE ? )  `;
                values.push('%' + search + '%');
            }
            let final = query;
            const setupsymptomsType = await this.connection.query(final, values);
            return setupsymptomsType;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAllSymptomsType(limit, page) {
        const offset = limit * (page - 1);
        const Symptoms_Type = await this.connection.query(`SELECT * FROM symptoms_classification LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM symptoms_classification`);
            let out = {
                details: Symptoms_Type,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findSymptomsTypeSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM symptoms_classification `;
            let countQuery = `
      SELECT COUNT(symptoms_classification.id) AS total 
      FROM symptoms_classification `;
            if (search) {
                const condition = `
      WHERE symptoms_classification.symptoms_type LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY symptoms_classification.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const SymptomsTypeSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: SymptomsTypeSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupSymptomsSymptomsTypeService = SetupSymptomsSymptomsTypeService;
exports.SetupSymptomsSymptomsTypeService = SetupSymptomsSymptomsTypeService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupSymptomsSymptomsTypeService);
//# sourceMappingURL=setup-symptoms-symptoms_type.service.js.map