"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupSymptomsSymptomsHeadService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupSymptomsSymptomsHeadService = class SetupSymptomsSymptomsHeadService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(symptoms_headEntity) {
        try {
            const result = await this.connection.query('INSERT INTO symptoms (symptoms_title,description,type) VALUES (?,?,?)', [
                symptoms_headEntity.symptoms_title,
                symptoms_headEntity.description,
                symptoms_headEntity.type,
            ]);
            await this.dynamicConnection.query(`INSERT INTO symptoms (symptoms_title,description,type,Hospital_id,hospital_symptoms_id) VALUES (?,?,?,?,?)`, [
                symptoms_headEntity.symptoms_title,
                symptoms_headEntity.description,
                symptoms_headEntity.type,
                symptoms_headEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SYMPTOMS,
                        inserted_data: await this.connection.query('SELECT * FROM symptoms WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const symptoms = await this.connection
                .query(`select symptoms.id,symptoms.symptoms_title as symptoms_head,symptoms.description,symptoms_classification.id as symptoms_type_id,symptoms_classification.symptoms_type from symptoms
    left join symptoms_classification on symptoms.type = symptoms_classification.id`);
            return symptoms;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const symptoms = await this.connection.query(`select symptoms.id,symptoms.symptoms_title as symptoms_head,symptoms.description,symptoms_classification.symptoms_type from symptoms
    left join symptoms_classification on symptoms.type = symptoms_classification.id WHERE id = ?`, [id]);
            if (symptoms.length === 1) {
                return symptoms;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, symptoms_headEntity) {
        try {
            await this.connection.query('UPDATE symptoms SET symptoms_title =? , description =?, type =? WHERE id = ?', [
                symptoms_headEntity.symptoms_title,
                symptoms_headEntity.description,
                symptoms_headEntity.type,
                id,
            ]);
            await this.dynamicConnection.query('update symptoms SET symptoms_title = ?,description =?, type =?  where hospital_symptoms_id = ? and Hospital_id= ?', [
                symptoms_headEntity.symptoms_title,
                symptoms_headEntity.description,
                symptoms_headEntity.type,
                id,
                symptoms_headEntity.Hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SYMPTOMS_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM symptoms WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM symptoms WHERE id = ?', [id]);
            const symptoms_head = await this.dynamicConnection.query(`select id from symptoms where hospital_symptoms_id = ?`, [id]);
            const symptoms = symptoms_head[0].id;
            await this.dynamicConnection.query(`delete from symptoms where id = ? and Hospital_id = ?`, [symptoms, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupSymptomsHead(search) {
        try {
            let query = ` select symptoms.id,symptoms.symptoms_title as symptoms_head,symptoms.description,symptoms_classification.id as symptoms_type_id,symptoms_classification.symptoms_type from symptoms
    left join symptoms_classification on symptoms.type = symptoms_classification.id `;
            let values = [];
            if (search) {
                query += ` WHERE ( symptoms.symptoms_title LIKE ? OR symptoms_classification.symptoms_type LIKE ? OR symptoms.description LIKE ? )  `;
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
            }
            let final = query;
            const SetupSymptomshead = await this.connection.query(final, values);
            return SetupSymptomshead;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAllSymptomsHead(limit, page) {
        const offset = limit * (page - 1);
        const Symptoms_Head = await this.connection.query(`select symptoms.id,symptoms.symptoms_title as symptoms_head,symptoms.description,symptoms_classification.id as symptoms_type_id,symptoms_classification.symptoms_type from symptoms
       left join symptoms_classification on symptoms.type = symptoms_classification.id LIMIT ? OFFSET ? `, [Number(limit), Number(offset)]);
        try {
            let [total_list] = await this.connection.query(`SELECT count(id) as total FROM symptoms`);
            let out = {
                details: Symptoms_Head,
                total: total_list.total,
            };
            return out;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findSymptomsHeadSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select symptoms.id,symptoms.symptoms_title as symptoms_head,symptoms.description,symptoms_classification.id as symptoms_type_id,symptoms_classification.symptoms_type from symptoms
    left join symptoms_classification on symptoms.type = symptoms_classification.id `;
            let countQuery = `
      SELECT COUNT(symptoms.id) AS total 
      FROM symptoms left join symptoms_classification on symptoms.type = symptoms_classification.id `;
            if (search) {
                const condition = `
      WHERE symptoms.symptoms_title LIKE ? OR symptoms_classification.symptoms_type LIKE ? OR symptoms.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY symptoms.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const SymptomsHeadSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: SymptomsHeadSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupSymptomsSymptomsHeadService = SetupSymptomsSymptomsHeadService;
exports.SetupSymptomsSymptomsHeadService = SetupSymptomsSymptomsHeadService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupSymptomsSymptomsHeadService);
//# sourceMappingURL=setup-symptoms-symptoms_head.service.js.map