"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupReferralReferralCommissionController = void 0;
const common_1 = require("@nestjs/common");
const setup_referral_referral_commission_service_1 = require("./setup-referral-referral_commission.service");
const auth_guard_1 = require("../auth/auth.guard");
let SetupReferralReferralCommissionController = class SetupReferralReferralCommissionController {
    constructor(setupReferralReferralCommissionService) {
        this.setupReferralReferralCommissionService = setupReferralReferralCommissionService;
    }
    create(referral_commissionEntity) {
        console.log(referral_commissionEntity);
        return this.setupReferralReferralCommissionService.create(referral_commissionEntity);
    }
    findAll() {
        return this.setupReferralReferralCommissionService.findAll();
    }
    update(referral_commissionEntity) {
        return this.setupReferralReferralCommissionService.update(referral_commissionEntity);
    }
    async remove(referral_category_id, Hospital_id) {
        const deletereferral_commission = await this.setupReferralReferralCommissionService.remove(referral_category_id, Hospital_id);
        return {
            status: `success`,
            message: `id: ${referral_category_id} deleted successfully`
        };
    }
    async findReferralCommissionSearch(search, limit, page) {
        try {
            let final_out = await this.setupReferralReferralCommissionService.findReferralCommissionSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupReferralReferralCommissionController = SetupReferralReferralCommissionController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], SetupReferralReferralCommissionController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupReferralReferralCommissionController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], SetupReferralReferralCommissionController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':referral_category_id'),
    __param(0, (0, common_1.Param)('referral_category_id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], SetupReferralReferralCommissionController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/Setup_Referral_Commission"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupReferralReferralCommissionController.prototype, "findReferralCommissionSearch", null);
exports.SetupReferralReferralCommissionController = SetupReferralReferralCommissionController = __decorate([
    (0, common_1.Controller)('setup-referral-referral-commission'),
    __metadata("design:paramtypes", [setup_referral_referral_commission_service_1.SetupReferralReferralCommissionService])
], SetupReferralReferralCommissionController);
//# sourceMappingURL=setup-referral-referral_commission.controller.js.map