"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupReferralReferralCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupReferralReferralCategoryService = class SetupReferralReferralCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(referral_categoryEntity) {
        try {
            const result = await this.connection.query('INSERT INTO referral_category (name,is_active) VALUES (?,?)', [referral_categoryEntity.name,
                referral_categoryEntity.is_active
            ]);
            await this.dynamicConnection.query(`INSERT INTO referral_category (name,is_active,Hospital_id,hospital_referral_category_id) VALUES (?,?,?,?)`, [
                referral_categoryEntity.name,
                referral_categoryEntity.is_active,
                referral_categoryEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.REFERRAL_CATEGORY,
                        "inserted_data": await this.connection.query('SELECT * FROM referral_category WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const referral_category = await this.connection.query('SELECT * FROM referral_category');
            return referral_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const referral_category = await this.connection.query('SELECT * FROM referral_category WHERE id = ?', [id]);
            if (referral_category.length === 1) {
                return referral_category;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, referral_categoryEntity) {
        try {
            await this.connection.query('UPDATE referral_category SET name =? WHERE id = ?', [referral_categoryEntity.name,
                id
            ]);
            await this.dynamicConnection.query('update referral_category SET name = ? where hospital_referral_category_id = ? and Hospital_id= ?', [referral_categoryEntity.name,
                id,
                referral_categoryEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.REFERRAL_CATEGORY_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM referral_category WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            const referral_category = await this.connection.query('SELECT * FROM referral_category WHERE id = ?', [id]);
            if (referral_category.length === 1) {
                return referral_category;
            }
            else {
                return null;
            }
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM referral_category WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from referral_category where hospital_referral_category_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from referral_category where id = ? and Hospital_id = ?`, [
                admin.id,
                Hospital_id
            ]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [{
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            }
        ];
    }
    async setupReferralCategory(search) {
        let query = ` SELECT * FROM referral_category `;
        let values = [];
        if (search) {
            query += ` WHERE ( referral_category.name LIKE ? )  `;
            values.push("%" + search + "%");
        }
        let final = query;
        const setupReferralcategory = await this.connection.query(final, values);
        return setupReferralcategory;
    }
    async findReferralCategorySearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM referral_category `;
            let countQuery = `
      SELECT COUNT(referral_category.id) AS total FROM referral_category `;
            if (search) {
                const condition = `
      WHERE referral_category.name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY referral_category.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const ReferralCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ReferralCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupReferralReferralCategoryService = SetupReferralReferralCategoryService;
exports.SetupReferralReferralCategoryService = SetupReferralReferralCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupReferralReferralCategoryService);
//# sourceMappingURL=setup-referral-referral_category.service.js.map