"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupRadiologyUnitService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupRadiologyUnitService = class SetupRadiologyUnitService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(unitEntity) {
        try {
            const [existingradiologyunit] = await this.connection.query(`
        SELECT id FROM unit WHERE unit_name = ? AND unit_type = 'radio' LIMIT 1`, [unitEntity.unit_name]);
            if (existingradiologyunit) {
                return [
                    {
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.EXISTING_RECORD,
                    },
                ];
            }
            const result = await this.connection.query('INSERT INTO unit (unit_name,unit_type) VALUES (?,?)', [unitEntity.unit_name, unitEntity.unit_type]);
            await this.dynamicConnection.query(`INSERT INTO unit (unit_name,unit_type,Hospital_id,hospital_unit_id) VALUES (?,?,?,?)`, [
                unitEntity.unit_name,
                unitEntity.unit_type,
                unitEntity.Hospital_id,
                result.insertId,
            ]);
            return [
                {
                    'data ': {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.UNIT,
                        inserted_data: await this.connection.query('SELECT * FROM unit WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne() {
        try {
            const unit = await this.connection.query('SELECT * FROM unit WHERE unit_type = ?', ['radio']);
            return unit;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, unitEntity) {
        try {
            await this.connection.query('UPDATE unit SET unit_name =? WHERE id = ?', [unitEntity.unit_name, id]);
            await this.dynamicConnection.query('update unit SET unit_name = ? where hospital_unit_id = ? and Hospital_id= ?', [unitEntity.unit_name, id, unitEntity.Hospital_id]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.UNIT_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM unit WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM unit WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from unit where hospital_unit_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from unit where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [
            {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            },
        ];
    }
    async findRadiologyUnitSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM unit WHERE unit_type = 'radio' `;
            let countQuery = `
      SELECT COUNT(unit.id) AS total FROM unit WHERE unit_type = 'radio' `;
            if (search) {
                const condition = `
      and ( unit.unit_name LIKE ? ) `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY unit.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyUnitSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyUnitSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findRadiologyUnitsSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM unit WHERE unit_type = 'radio' `;
            let countQuery = `
      SELECT COUNT(unit.id) AS total FROM unit WHERE unit_type = 'radio' `;
            if (search) {
                const condition = `
      and ( unit.unit_name LIKE ? ) `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY unit.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyUnitSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyUnitSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupRadiologyUnitService = SetupRadiologyUnitService;
exports.SetupRadiologyUnitService = SetupRadiologyUnitService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupRadiologyUnitService);
//# sourceMappingURL=setup-radiology-unit.service.js.map