"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupRadiologyRadiologyParameterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupRadiologyRadiologyParameterService = class SetupRadiologyRadiologyParameterService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(radiology_parameterEntity) {
        try {
            const result = await this.connection.query('INSERT INTO radiology_parameter (parameter_name,test_value,reference_range,gender,unit,description) VALUES (?,?,?,?,?,?)', [radiology_parameterEntity.parameter_name,
                radiology_parameterEntity.test_value,
                radiology_parameterEntity.reference_range,
                radiology_parameterEntity.gender,
                radiology_parameterEntity.unit,
                radiology_parameterEntity.description
            ]);
            await this.dynamicConnection.query(`INSERT INTO radiology_parameter
     (parameter_name,test_value,reference_range,gender,unit,description,Hospital_id,hospital_radiology_parameter_id) VALUES (?,?,?,?,?,?,?,?)`, [
                radiology_parameterEntity.parameter_name,
                radiology_parameterEntity.test_value,
                radiology_parameterEntity.reference_range,
                radiology_parameterEntity.gender,
                radiology_parameterEntity.unit,
                radiology_parameterEntity.description,
                radiology_parameterEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.RADIOLOGY,
                        "inserted_data": await this.connection.query('SELECT * FROM radiology_parameter WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const radiology_parameter = await this.connection.query(`select radiology_parameter.id,radiology_parameter.parameter_name,radiology_parameter.reference_range,unit.unit_name,radiology_parameter.description from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id ;`);
            return radiology_parameter;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const radiology_parameter = await this.connection.query(`select radiology_parameter.id,radiology_parameter.parameter_name,radiology_parameter.reference_range,unit.unit_name,radiology_parameter.description from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id WHERE radiology_parameter.id = ? `, [id]);
            if (radiology_parameter.length === 1) {
                return radiology_parameter;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, radiology_parameterEntity) {
        try {
            await this.connection.query('UPDATE radiology_parameter SET parameter_name =?,reference_range =?,unit =?,description =? WHERE id = ?', [radiology_parameterEntity.parameter_name,
                radiology_parameterEntity.reference_range,
                radiology_parameterEntity.unit,
                radiology_parameterEntity.description,
                id
            ]);
            await this.dynamicConnection.query('update radiology_parameter SET parameter_name = ?,reference_range = ?,unit = ?,description = ? where hospital_radiology_parameter_id = ? and Hospital_id= ?', [radiology_parameterEntity.parameter_name,
                radiology_parameterEntity.reference_range,
                radiology_parameterEntity.unit,
                radiology_parameterEntity.description,
                id,
                radiology_parameterEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.RADIOLOGY_PARAMETER,
                        "updated_values": await this.connection.query('SELECT * FROM radiology_parameter WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            const radiology_parameter = await this.connection.query(`select radiology_parameter.id,radiology_parameter.parameter_name,radiology_parameter.reference_range,unit.unit_name,radiology_parameter.description from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id WHERE radiology_parameter.id = ? `, [id]);
            if (radiology_parameter.length === 1) {
                return radiology_parameter;
            }
            else {
                return null;
            }
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM radiology_parameter WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from radiology_parameter where hospital_radiology_parameter_id = ? `, [id]);
            await this.dynamicConnection.query(`delete from radiology_parameter where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [{
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.DELETED
            }
        ];
    }
    async findRadiologyParameterSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select radiology_parameter.id,radiology_parameter.parameter_name,radiology_parameter.reference_range,unit.unit_name,radiology_parameter.description from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id `;
            let countQuery = `
      SELECT COUNT(radiology_parameter.id) AS total from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id `;
            if (search) {
                const condition = `
      WHERE radiology_parameter.parameter_name LIKE ? OR radiology_parameter.reference_range LIKE ? OR unit.unit_name LIKE ? OR radiology_parameter.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY radiology_parameter.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyParameterSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyParameterSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findRadiologyParametersSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select radiology_parameter.id,radiology_parameter.parameter_name,radiology_parameter.reference_range,unit.unit_name,radiology_parameter.description from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id `;
            let countQuery = `
      SELECT COUNT(radiology_parameter.id) AS total from radiology_parameter
    left join unit on radiology_parameter.unit = unit.id `;
            if (search) {
                const condition = `
      WHERE radiology_parameter.parameter_name LIKE ? OR radiology_parameter.reference_range LIKE ? OR unit.unit_name LIKE ? OR radiology_parameter.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY radiology_parameter.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyParameterSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyParameterSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupRadiologyRadiologyParameterService = SetupRadiologyRadiologyParameterService;
exports.SetupRadiologyRadiologyParameterService = SetupRadiologyRadiologyParameterService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupRadiologyRadiologyParameterService);
//# sourceMappingURL=setup-radiology-radiology_parameter.service.js.map