"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupRadiologyRadiologyCategoryService = void 0;
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const common_1 = require("@nestjs/common");
let SetupRadiologyRadiologyCategoryService = class SetupRadiologyRadiologyCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(radiology_categoryEntity) {
        try {
            const result = await this.connection.query('INSERT INTO lab (lab_name) VALUES (?)', [radiology_categoryEntity.lab_name
            ]);
            await this.dynamicConnection.query(`INSERT INTO lab (lab_name,Hospital_id,hospital_lab_id) VALUES (?,?,?)`, [
                radiology_categoryEntity.lab_name,
                radiology_categoryEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.LAB,
                        "inserted_data": await this.connection.query('SELECT * FROM lab WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const lab = await this.connection.query('SELECT * FROM lab');
            return lab;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const lab = await this.connection.query('SELECT * FROM lab WHERE id = ?', [id]);
            if (lab.length === 1) {
                return lab;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, radiology_categoryEntity) {
        try {
            await this.connection.query('UPDATE lab SET lab_name =? WHERE id = ?', [radiology_categoryEntity.lab_name,
                id
            ]);
            await this.dynamicConnection.query('update lab SET lab_name = ? where hospital_lab_id = ? and Hospital_id= ?', [radiology_categoryEntity.lab_name,
                id,
                radiology_categoryEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.LAB_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM lab WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM lab WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from lab where hospital_lab_id = ? `, [id]);
            await this.dynamicConnection.query(`delete from lab where id = ? and Hospital_id = ? `, [
                admin.id,
                Hospital_id
            ]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [{
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.ERROR_MESSAGE,
            }
        ];
    }
    async findRadiologyCategorySearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM lab `;
            let countQuery = `
      SELECT COUNT(lab.id) AS total FROM lab `;
            if (search) {
                const condition = `
      WHERE lab.lab_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY lab.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findRadiologyCategorysSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM lab `;
            let countQuery = `
      SELECT COUNT(lab.id) AS total FROM lab `;
            if (search) {
                const condition = `
      WHERE lab.lab_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY lab.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const RadiologyCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: RadiologyCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupRadiologyRadiologyCategoryService = SetupRadiologyRadiologyCategoryService;
exports.SetupRadiologyRadiologyCategoryService = SetupRadiologyRadiologyCategoryService = __decorate([
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupRadiologyRadiologyCategoryService);
//# sourceMappingURL=setup-radiology-radiology_category.service.js.map