"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPharmacyDoseIntervalService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupPharmacyDoseIntervalService = class SetupPharmacyDoseIntervalService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(dose_intervalEntity) {
        try {
            const result = await this.connection.query('INSERT INTO dose_interval (name) VALUES (?)', [dose_intervalEntity.name
            ]);
            await this.dynamicConnection.query(`INSERT INTO dose_interval (name,Hospital_id,hospital_dose_interval_id) VALUES (?,?,?)`, [
                dose_intervalEntity.name,
                dose_intervalEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": "success",
                        "messege": "dose_interval details added successfully ",
                        "inserted_data": await this.connection.query('SELECT * FROM dose_interval WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const dose_interval = await this.connection.query('SELECT * FROM dose_interval');
            return dose_interval;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_interval WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const dose_interval = await this.connection.query('SELECT * FROM dose_interval WHERE id = ?', [id]);
            return dose_interval;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, dose_intervalEntity) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_interval WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE dose_interval SET name =? WHERE id = ?', [dose_intervalEntity.name,
                id
            ]);
            await this.dynamicConnection.query('update dose_interval SET name = ? where hospital_dose_interval_id = ? and Hospital_id= ?', [dose_intervalEntity.name,
                id,
                dose_intervalEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "dose_interval details updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM dose_interval WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM dose_interval WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: 'identity',
                message: `ID ${id} does not exist or has already been deleted`,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM dose_interval WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from dose_interval where hospital_dose_interval_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from dose_interval where id = ? and Hospital_id = ?`, [
                admin.id,
                Hospital_id
            ]);
            return [{
                    "status": "success",
                    "message": " id: " + id + " deleted successfully"
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: `THE API SERVICE IS TEMPORARILY UNAVAILABLE. PLEASE TRY AGAIN LATER.`,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupPharmacyDoseInterval(search) {
        let query = ` SELECT * FROM dose_interval `;
        let values = [];
        if (search) {
            query += ` WHERE ( dose_interval.name LIKE ? ) `;
            values.push('%' + search + '%');
        }
        let final = query;
        const setupPharmacyDoseIntervalSearch = await this.connection.query(final, values);
        return setupPharmacyDoseIntervalSearch;
    }
};
exports.SetupPharmacyDoseIntervalService = SetupPharmacyDoseIntervalService;
exports.SetupPharmacyDoseIntervalService = SetupPharmacyDoseIntervalService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupPharmacyDoseIntervalService);
//# sourceMappingURL=setup-pharmacy-dose_interval.service.js.map