"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPatientNewPatientController = void 0;
const common_1 = require("@nestjs/common");
const setup_patient_new_patient_service_1 = require("./setup-patient-new_patient.service");
const setup_patient_new_patient_entity_1 = require("./entities/setup-patient-new_patient.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupPatientNewPatientController = class SetupPatientNewPatientController {
    constructor(setupPatientNewPatientService) {
        this.setupPatientNewPatientService = setupPatientNewPatientService;
    }
    create(new_patientEntity) {
        return this.setupPatientNewPatientService.create(new_patientEntity);
    }
    findAll() {
        return this.setupPatientNewPatientService.findAll();
    }
    findOne(id) {
        return this.setupPatientNewPatientService.findOne(id);
    }
    update(id, new_patientEntity) {
        return this.setupPatientNewPatientService.update(id, new_patientEntity);
    }
    remove(id) {
        return this.setupPatientNewPatientService.remove(id);
    }
    setupNewPatient(search) {
        console.log(search, 'zzzzzz');
        return this.setupPatientNewPatientService.setupNewPatient(search);
    }
    disablePatList() {
        return this.setupPatientNewPatientService.disablePatList();
    }
    SetupDisabledPatient(search) {
        console.log(search, 'zzzzzz');
        return this.setupPatientNewPatientService.SetupDisabledPatient(search);
    }
    checkOldPatient(search) {
        console.log(search, 'zzzzzz');
        return this.setupPatientNewPatientService.checkOldPatient(search);
    }
    getPatientDetailsWithAayush(search) {
        console.log(search, 'zzzzzz');
        return this.setupPatientNewPatientService.getPatientDetailsWithAayush(search);
    }
    async findAllDesig(limit, page, search, fromDate, toDate) {
        try {
            const final_output = await this.setupPatientNewPatientService.findallpatients(limit || 10, page || 1, search || '', fromDate || '', toDate || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalPages: Math.ceil(final_output.total / final_output.limit),
                };
            }
            return this.setupPatientNewPatientService.findallpatients(limit, page, search, fromDate, toDate);
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findOneDesig(id) {
        try {
            const final_output = await this.setupPatientNewPatientService.patient_info(id);
            if (final_output) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output,
                };
            }
            else {
                return {
                    status_code: process.env.ERROR_STATUS_CODE,
                    status: process.env.ERROR_STATUS,
                    message: process.env.ERROR_MESSAGE,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findAllDesigV3(limit, page, search, fromDate, toDate) {
        try {
            const final_output = await this.setupPatientNewPatientService.V3findallpatients(limit || 10, page || 1, search || '', fromDate || '', toDate || '');
            return final_output;
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    findid(id) {
        return this.setupPatientNewPatientService.findPATIENT_ID(id);
    }
};
exports.SetupPatientNewPatientController = SetupPatientNewPatientController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_patient_new_patient_entity_1.SetupPatientNewPatient]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, setup_patient_new_patient_entity_1.SetupPatientNewPatient]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/setupNewPatient/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "setupNewPatient", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/patient/disabled'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "disablePatList", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupDisabledPatient/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "SetupDisabledPatient", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/checkPatient/WithMobileNo'),
    __param(0, (0, common_1.Query)('mobile')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "checkOldPatient", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/getPatient/WithAayushId'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "getPatientDetailsWithAayush", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpatient'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('fromDate')),
    __param(4, (0, common_1.Query)('toDate')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String, String]),
    __metadata("design:returntype", Promise)
], SetupPatientNewPatientController.prototype, "findAllDesig", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpatient/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], SetupPatientNewPatientController.prototype, "findOneDesig", null);
__decorate([
    (0, common_1.Get)('/v3/getAllpatient'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('fromDate')),
    __param(4, (0, common_1.Query)('toDate')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String, String]),
    __metadata("design:returntype", Promise)
], SetupPatientNewPatientController.prototype, "findAllDesigV3", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('unique/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPatientNewPatientController.prototype, "findid", null);
exports.SetupPatientNewPatientController = SetupPatientNewPatientController = __decorate([
    (0, common_1.Controller)('setup-patient-new-patient'),
    __metadata("design:paramtypes", [setup_patient_new_patient_service_1.SetupPatientNewPatientService])
], SetupPatientNewPatientController);
//# sourceMappingURL=setup-patient-new_patient.controller.js.map