"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPatientDisabledPatientListService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let SetupPatientDisabledPatientListService = class SetupPatientDisabledPatientListService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll() {
        try {
            const patients = await this.connection.query(`select patients.id, patients.patient_name,concat(patients.age,"year",
      patients.month,"month",patients.day,"day") AS dob,patients.age,patients.gender,patients.mobileno,patients.guardian_name,
      patients.address,patients.is_dead,patients.insurance_id,patients.insurance_validity from patients where is_active = ?`, ['no']);
            return patients;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, data) {
        try {
            const { is_active, ...otherData } = data;
            console.log(otherData, is_active, "dd");
            const updateQuery = `UPDATE patients
                         SET is_active = ?,  
                             ${Object.keys(otherData).map(key => `${key} = ?`).join(', ')}
                         WHERE id = ?`;
            const updateValues = [is_active, ...Object.values(otherData), id];
            const result = await this.connection.query(updateQuery, updateValues);
            return result;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findDisablePatientSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select patients.id, patients.patient_name,patients.age,patients.gender,patients.mobileno,patients.guardian_name,patients.address,patients.is_dead,patients.insurance_id,patients.insurance_validity from patients where is_active = 'no' `;
            let countQuery = `
      SELECT COUNT(patients.id) AS total from patients where is_active = 'no' `;
            if (search) {
                const condition = `
      and ( patients.id LIKE ? OR patients.patient_name LIKE ? OR patients.age LIKE ? OR patients.gender LIKE ? OR patients.mobileno LIKE ? OR patients.guardian_name LIKE ? OR patients.address LIKE ? ) `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY patients.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const DisabledPatientSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: DisabledPatientSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findDisablePatientsSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select patients.id, patients.patient_name,patients.age,patients.gender,patients.mobileno,patients.guardian_name,patients.address,patients.is_dead,patients.insurance_id,patients.insurance_validity from patients where is_active = 'no' `;
            let countQuery = `
      SELECT COUNT(patients.id) AS total from patients where is_active = 'no' `;
            if (search) {
                const condition = `
      and ( patients.id LIKE ? OR patients.patient_name LIKE ? OR patients.age LIKE ? OR patients.gender LIKE ? OR patients.mobileno LIKE ? OR patients.guardian_name LIKE ? OR patients.address LIKE ? ) `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY patients.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const DisabledPatientSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: DisabledPatientSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupPatientDisabledPatientListService = SetupPatientDisabledPatientListService;
exports.SetupPatientDisabledPatientListService = SetupPatientDisabledPatientListService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], SetupPatientDisabledPatientListService);
//# sourceMappingURL=setup-patient-disabled_patient_list.service.js.map