"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPathologyUnitController = void 0;
const common_1 = require("@nestjs/common");
const setup_pathology_unit_service_1 = require("./setup-pathology-unit.service");
const setup_pathology_unit_entity_1 = require("./entities/setup-pathology-unit.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupPathologyUnitController = class SetupPathologyUnitController {
    constructor(setupPathologyUnitService) {
        this.setupPathologyUnitService = setupPathologyUnitService;
    }
    create(unitEntity) {
        return this.setupPathologyUnitService.create(unitEntity);
    }
    findAll() {
        return this.setupPathologyUnitService.findAll();
    }
    update(id, unitEntity) {
        return this.setupPathologyUnitService.update(id, unitEntity);
    }
    remove(id, Hospital_id) {
        return this.setupPathologyUnitService.remove(id, Hospital_id);
    }
    async findPathologyUnitSearch(search, limit, page) {
        try {
            let final_out = await this.setupPathologyUnitService.findPathologyUnitSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
    async findPathologyUnitsSearch(search, limit, page) {
        try {
            let final_out = await this.setupPathologyUnitService.findPathologyUnitsSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupPathologyUnitController = SetupPathologyUnitController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_pathology_unit_entity_1.SetupPathologyUnit]),
    __metadata("design:returntype", void 0)
], SetupPathologyUnitController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupPathologyUnitController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_pathology_unit_entity_1.SetupPathologyUnit]),
    __metadata("design:returntype", void 0)
], SetupPathologyUnitController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], SetupPathologyUnitController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/Setup_Pathology_Unit"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupPathologyUnitController.prototype, "findPathologyUnitSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v3/Setup_Pathology_Unit"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupPathologyUnitController.prototype, "findPathologyUnitsSearch", null);
exports.SetupPathologyUnitController = SetupPathologyUnitController = __decorate([
    (0, common_1.Controller)('setup-pathology-unit'),
    __metadata("design:paramtypes", [setup_pathology_unit_service_1.SetupPathologyUnitService])
], SetupPathologyUnitController);
//# sourceMappingURL=setup-pathology-unit.controller.js.map