"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPathologyPathologyParameterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupPathologyPathologyParameterService = class SetupPathologyPathologyParameterService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(pathology_parameterEntity) {
        try {
            const result = await this.connection.query('INSERT INTO pathology_parameter (parameter_name,test_value,reference_range,gender,unit,description) VALUES (?,?,?,?,?,?)', [pathology_parameterEntity.parameter_name,
                pathology_parameterEntity.test_value,
                pathology_parameterEntity.reference_range,
                pathology_parameterEntity.gender,
                pathology_parameterEntity.unit,
                pathology_parameterEntity.description
            ]);
            const [patho_unit] = await this.dynamicConnection.query(`select id from unit where Hospital_id = ? and hospital_unit_id = ?`, [pathology_parameterEntity.Hospital_id,
                pathology_parameterEntity.unit]);
            const AdminCategory = await this.dynamicConnection.query('Insert into pathology_parameter (parameter_name,test_value,reference_range,gender,unit,description,Hospital_id,hospital_pathology_parameter_id) VALUES (?,?,?,?,?,?,?,?)', [
                pathology_parameterEntity.parameter_name,
                pathology_parameterEntity.test_value,
                pathology_parameterEntity.reference_range,
                pathology_parameterEntity.gender,
                patho_unit.id,
                pathology_parameterEntity.description,
                pathology_parameterEntity.Hospital_id,
                result.insertId
            ]);
            return [{ "data ": { "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.PATHOLOGY_PARAMETER,
                        "inserted_data": await this.connection.query('SELECT * FROM pathology_parameter WHERE id = ?', [result.insertId])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const unit = await this.connection.query(`select pathology_parameter.id,pathology_parameter.parameter_name,pathology_parameter.reference_range,unit.unit_name,pathology_parameter.description from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id`);
            return unit;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const unit = await this.connection.query(`select pathology_parameter.id,pathology_parameter.parameter_name,pathology_parameter.reference_range,unit.unit_name,pathology_parameter.description from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id WHERE pathology_parameter.id = ?`, [id]);
            if (unit.length === 1) {
                return unit;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, pathology_parameterEntity) {
        try {
            await this.connection.query('UPDATE pathology_parameter SET parameter_name =?,reference_range =?,unit =?,description =? WHERE id = ?', [pathology_parameterEntity.parameter_name,
                pathology_parameterEntity.reference_range,
                pathology_parameterEntity.unit,
                pathology_parameterEntity.description,
                id
            ]);
            await this.dynamicConnection.query('update pathology_parameter SET parameter_name = ?,reference_range =?,unit =? ,description =? Where hospital_pathology_parameter_id =? and Hospital_id = ?', [
                pathology_parameterEntity.parameter_name,
                pathology_parameterEntity.reference_range,
                pathology_parameterEntity.unit,
                pathology_parameterEntity.description,
                id,
                pathology_parameterEntity.Hospital_id
            ]);
            return [{ "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.PATHOLOGY_PARAMETER_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM pathology_parameter WHERE id = ?', [id])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM pathology_parameter WHERE id = ?', [id]);
            const pathology_parameter = await this.dynamicConnection.query(`select id from pathology_parameter where hospital_pathology_parameter_id = ?`, [id]);
            const patho = pathology_parameter[0].id;
            console.log("patho", patho);
            await this.dynamicConnection.query(`delete from pathology_parameter where id = ? and Hospital_id = ?`, [patho, Hospital_id]);
            return [{
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPathologyParameterSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select pathology_parameter.id,pathology_parameter.parameter_name,pathology_parameter.reference_range,unit.unit_name,pathology_parameter.description from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id `;
            let countQuery = `
      SELECT COUNT(pathology_parameter.id) AS total from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id `;
            if (search) {
                const condition = `
      WHERE pathology_parameter.parameter_name LIKE ? OR pathology_parameter.reference_range LIKE ? OR unit.unit_name LIKE ? OR pathology_parameter.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY pathology_parameter.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const PathologyParameterSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: PathologyParameterSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPathologyParametersSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      select pathology_parameter.id,pathology_parameter.parameter_name,pathology_parameter.reference_range,unit.unit_name,pathology_parameter.description from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id `;
            let countQuery = `
      SELECT COUNT(pathology_parameter.id) AS total from pathology_parameter
    left join unit on pathology_parameter.unit = unit.id `;
            if (search) {
                const condition = `
      WHERE pathology_parameter.parameter_name LIKE ? OR pathology_parameter.reference_range LIKE ? OR unit.unit_name LIKE ? OR pathology_parameter.description LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY pathology_parameter.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const PathologyParameterSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: PathologyParameterSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupPathologyPathologyParameterService = SetupPathologyPathologyParameterService;
exports.SetupPathologyPathologyParameterService = SetupPathologyPathologyParameterService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupPathologyPathologyParameterService);
//# sourceMappingURL=setup-pathology-pathology_parameter.service.js.map