"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPathologyPathologyParameterController = void 0;
const common_1 = require("@nestjs/common");
const setup_pathology_pathology_parameter_entity_1 = require("./entities/setup-pathology-pathology_parameter.entity");
const setup_pathology_pathology_parameter_service_1 = require("./setup-pathology-pathology_parameter.service");
const auth_guard_1 = require("../auth/auth.guard");
let SetupPathologyPathologyParameterController = class SetupPathologyPathologyParameterController {
    constructor(pathology_parameterService) {
        this.pathology_parameterService = pathology_parameterService;
    }
    create(pathology_parameterEntity) {
        return this.pathology_parameterService.create(pathology_parameterEntity);
    }
    findAll() {
        return this.pathology_parameterService.findAll();
    }
    findOne(id) {
        return this.pathology_parameterService.findOne(id);
    }
    update(id, pathology_parameterEntity) {
        return this.pathology_parameterService.update(id, pathology_parameterEntity);
    }
    async remove(id, Hospital_id) {
        const deletepatho = await this.pathology_parameterService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`
        };
    }
    async findPathologyParameterSearch(search, limit, page) {
        try {
            let final_out = await this.pathology_parameterService.findPathologyParameterSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
    async findPathologyParametersSearch(search, limit, page) {
        try {
            let final_out = await this.pathology_parameterService.findPathologyParametersSearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupPathologyPathologyParameterController = SetupPathologyPathologyParameterController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_pathology_pathology_parameter_entity_1.SetupPathologyPathologyParameter]),
    __metadata("design:returntype", void 0)
], SetupPathologyPathologyParameterController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupPathologyPathologyParameterController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupPathologyPathologyParameterController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_pathology_pathology_parameter_entity_1.SetupPathologyPathologyParameter]),
    __metadata("design:returntype", void 0)
], SetupPathologyPathologyParameterController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], SetupPathologyPathologyParameterController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v2/Setup_Pathology_Parameter"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupPathologyPathologyParameterController.prototype, "findPathologyParameterSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)("/v3/Setup_Pathology_Parameter"),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)("limit")),
    __param(2, (0, common_1.Query)("page")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SetupPathologyPathologyParameterController.prototype, "findPathologyParametersSearch", null);
exports.SetupPathologyPathologyParameterController = SetupPathologyPathologyParameterController = __decorate([
    (0, common_1.Controller)('setup-pathology-pathology-parameter'),
    __metadata("design:paramtypes", [setup_pathology_pathology_parameter_service_1.SetupPathologyPathologyParameterService])
], SetupPathologyPathologyParameterController);
//# sourceMappingURL=setup-pathology-pathology_parameter.controller.js.map