"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPathologyPathologyCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupPathologyPathologyCategoryService = class SetupPathologyPathologyCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(pathology_categoryEntity) {
        const [existingpatho_cate] = await this.connection.query(`
      SELECT id FROM pathology_category WHERE category_name = ? LIMIT 1`, [pathology_categoryEntity.category_name]);
        if (existingpatho_cate) {
            return [{
                    status: process.env.DUPLICATE_NAME,
                    message: process.env.EXISTING_RECORD,
                }];
        }
        try {
            const result = await this.connection.query('INSERT INTO pathology_category (category_name) VALUES (?)', [pathology_categoryEntity.category_name
            ]);
            await this.dynamicConnection.query(`INSERT INTO pathology_category (category_name,Hospital_id,hospital_pathology_category_id) VALUES (?,?,?)`, [
                pathology_categoryEntity.category_name,
                pathology_categoryEntity.Hospital_id,
                result.insertId
            ]);
            return [{ "data ": { "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.PATHOLOGY_CATEGORY,
                        "inserted_data": await this.connection.query('SELECT * FROM pathology_category WHERE id = ?', [result.insertId])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const pathology_category = await this.connection.query('SELECT * FROM pathology_category');
            return pathology_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM pathology_category WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const pathology_category = await this.connection.query('SELECT * FROM pathology_category WHERE id = ?', [id]);
            if (pathology_category.length === 1) {
                return pathology_category;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, pathology_categoryEntity) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM pathology_category WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE pathology_category SET category_name =? WHERE id = ?', [pathology_categoryEntity.category_name,
                id
            ]);
            await this.dynamicConnection.query('update pathology_category SET category_name = ? where hospital_pathology_category_id =? and Hospital_id= ?', [pathology_categoryEntity.category_name,
                id,
                pathology_categoryEntity.Hospital_id
            ]);
            return [{ "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "message": process.env.PATHOLOGY_CATEGORY_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM pathology_category WHERE id = ?', [id])
                    } }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM pathology_category WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM pathology_category WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from pathology_category where hospital_pathology_category_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from pathology_category where id = ? and Hospital_id = ?`, [
                admin.id,
                Hospital_id
            ]);
            return [{
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPathologyCategorySearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM pathology_category `;
            let countQuery = `
      SELECT COUNT(pathology_category.id) AS total FROM pathology_category `;
            if (search) {
                const condition = `
      WHERE pathology_category.category_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY pathology_category.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const PathologyCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: PathologyCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findPathologyCategorysSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM pathology_category `;
            let countQuery = `
      SELECT COUNT(pathology_category.id) AS total FROM pathology_category `;
            if (search) {
                const condition = `
      WHERE pathology_category.category_name LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern);
            }
            baseQuery += ` ORDER BY pathology_category.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const PathologyCategorySearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: PathologyCategorySearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupPathologyPathologyCategoryService = SetupPathologyPathologyCategoryService;
exports.SetupPathologyPathologyCategoryService = SetupPathologyPathologyCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupPathologyPathologyCategoryService);
//# sourceMappingURL=setup-pathology-pathology_category.service.js.map