"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupOperationOperationCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupOperationOperationCategoryService = class SetupOperationOperationCategoryService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(operation_categoryrEntity) {
        try {
            const [existingExpense] = await this.connection.query(`
        SELECT id FROM operation_category WHERE category = ? LIMIT 1`, [operation_categoryrEntity.category]);
            if (existingExpense) {
                return [{
                        status: process.env.DUPLICATE_NAME,
                        message: process.env.OPERATION_CATEGORY_EXIST,
                    }];
            }
            const result = await this.connection.query('INSERT INTO operation_category (category,is_active) VALUES (?,?)', [operation_categoryrEntity.category,
                operation_categoryrEntity.is_active
            ]);
            await this.dynamicConnection.query(`INSERT INTO operation_category(category,is_active,Hospital_id,hospital_operation_category_id) values (?,?,?,?)`, [
                operation_categoryrEntity.category,
                operation_categoryrEntity.is_active,
                operation_categoryrEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data": {
                        "id": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "message": process.env.OPERATION_CATEGORY,
                        "inserted_data": await this.connection.query('SELECT * FROM operation_category WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const operation_category = await this.connection.query('SELECT * FROM operation_category');
            return operation_category;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id from operation_category WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const unit = await this.connection.query('SELECT * FROM operation_category WHERE id = ?', [id]);
            return unit;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, operation_categoryEntity) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM operation_category WHERE id = ?`, [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('UPDATE operation_category SET category =? WHERE id = ?', [operation_categoryEntity.category,
                id
            ]);
            await this.dynamicConnection.query('update operation_category SET category = ? where hospital_operation_category_id =? and Hospital_id = ?', [operation_categoryEntity.category,
                id,
                operation_categoryEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.OPERATION_CATEGORY_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM operation_category WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM operation_category WHERE id = ?`, [id]);
        if (!existingRecord) {
            return [{ status: process.env.ERROR,
                    message: process.env.EXISTING_RECORD }];
        }
        try {
            await this.connection.query('DELETE FROM operation_category WHERE id = ?', [id]);
            const operation_category = await this.dynamicConnection.query(`select id from operation_category where hospital_operation_category_id = ?`, [id]);
            const oper_cat = operation_category[0].id;
            await this.dynamicConnection.query(`delete from operation_category where id = ? and Hospital_id = ?`, [oper_cat, Hospital_id]);
            return [{
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                }
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async setupOperationcategory(search) {
        let query = ` SELECT * FROM operation_category `;
        let values = [];
        if (search) {
            query += ` WHERE ( operation_category.category LIKE ? )  `;
            values.push("%" + search + "%");
        }
        let final = query;
        const OperationCategorySearch = await this.connection.query(final, values);
        return OperationCategorySearch;
    }
    async findalloperation_category(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let searchClause = '';
            if (search) {
                searchClause = `operation_category.category LIKE '%${search}%'`;
            }
            const baseWhereClause = `WHERE 1=1 ${searchClause ? `AND ${searchClause}` : ''}`;
            const operation_category = await this.connection.query(`
      SELECT operation_category.id, operation_category.category, operation_category.is_active 
      FROM operation_category
      ${baseWhereClause}
      LIMIT ? OFFSET ?`, [Number(limit), Number(offset)]);
            const [totalList] = await this.connection.query(`
      SELECT COUNT(operation_category.id) AS total 
      FROM operation_category
      ${baseWhereClause}
    `);
            let variable = {
                details: operation_category,
                total: totalList.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupOperationOperationCategoryService = SetupOperationOperationCategoryService;
exports.SetupOperationOperationCategoryService = SetupOperationOperationCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupOperationOperationCategoryService);
//# sourceMappingURL=setup-operation-operation_category.service.js.map