"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupOperationOperationController = void 0;
const common_1 = require("@nestjs/common");
const setup_operation_operation_service_1 = require("./setup-operation-operation.service");
const setup_operation_operation_entity_1 = require("./entities/setup-operation-operation.entity");
const auth_guard_1 = require("../auth/auth.guard");
let SetupOperationOperationController = class SetupOperationOperationController {
    constructor(setupOperationOperationService) {
        this.setupOperationOperationService = setupOperationOperationService;
    }
    create(operationEntity) {
        return this.setupOperationOperationService.create(operationEntity);
    }
    findAll() {
        return this.setupOperationOperationService.findAll();
    }
    findOne(id) {
        return this.setupOperationOperationService.findOne(id);
    }
    update(id, operationEntity) {
        return this.setupOperationOperationService.update(id, operationEntity);
    }
    async remove(id, Hospital_id) {
        return this.setupOperationOperationService.remove(id, Hospital_id);
    }
    setupOperation(search) {
        console.log(search, "zzzzzz");
        return this.setupOperationOperationService.setupOperation(search);
    }
    async findalloperation(limit, page, search) {
        try {
            let final_output = await this.setupOperationOperationService.getoperation(limit || 10, page || 1, search || '');
            console.log("controller");
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit),
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.SetupOperationOperationController = SetupOperationOperationController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [setup_operation_operation_entity_1.SetupOperationOperation]),
    __metadata("design:returntype", void 0)
], SetupOperationOperationController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SetupOperationOperationController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupOperationOperationController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, setup_operation_operation_entity_1.SetupOperationOperation]),
    __metadata("design:returntype", void 0)
], SetupOperationOperationController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], SetupOperationOperationController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/operation/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SetupOperationOperationController.prototype, "setupOperation", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getalloperation'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], SetupOperationOperationController.prototype, "findalloperation", null);
exports.SetupOperationOperationController = SetupOperationOperationController = __decorate([
    (0, common_1.Controller)('setup-operation-operation'),
    __metadata("design:paramtypes", [setup_operation_operation_service_1.SetupOperationOperationService])
], SetupOperationOperationController);
//# sourceMappingURL=setup-operation-operation.controller.js.map