"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupInventoryItemSupplierService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupInventoryItemSupplierService = class SetupInventoryItemSupplierService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(item_supplierEntity) {
        try {
            const result = await this.connection.query('INSERT INTO item_supplier (item_supplier,phone,email,address,contact_person_name,contact_person_phone,contact_person_email,description) VALUES (?,?,?,?,?,?,?,?)', [item_supplierEntity.item_supplier,
                item_supplierEntity.phone,
                item_supplierEntity.email,
                item_supplierEntity.address,
                item_supplierEntity.contact_person_name,
                item_supplierEntity.contact_person_phone,
                item_supplierEntity.contact_person_email,
                item_supplierEntity.description
            ]);
            await this.dynamicConnection.query('INSERT INTO item_supplier (item_supplier,phone,email,address,contact_person_name,contact_person_phone,contact_person_email,description,Hospital_id,hospital_item_supplier_id) VALUES (?,?,?,?,?,?,?,?,?,?)', [
                item_supplierEntity.item_supplier,
                item_supplierEntity.phone,
                item_supplierEntity.email,
                item_supplierEntity.address,
                item_supplierEntity.contact_person_name,
                item_supplierEntity.contact_person_phone,
                item_supplierEntity.contact_person_email,
                item_supplierEntity.description,
                item_supplierEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_SUPPLIER,
                        "inserted_data": await this.connection.query('SELECT * FROM item_supplier WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const item_supplier = await this.connection.query('SELECT * FROM item_supplier');
            return item_supplier;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [EXISTING_RECORD] = await this.connection.query(`
      SELECT id FROM item_supplier WHERE id = ?`, [
            id
        ]);
        if (!EXISTING_RECORD || EXISTING_RECORD.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const item_supplier = await this.connection.query('SELECT * FROM item_supplier WHERE id = ?', [id]);
            if (item_supplier.length === 1) {
                return item_supplier;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, item_supplierEntity) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM item_supplier WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE item_supplier SET item_supplier =?, phone =?, email =?, address =?, contact_person_name =?, contact_person_phone =?, contact_person_email =?, description =?  WHERE id = ?', [item_supplierEntity.item_supplier,
                item_supplierEntity.phone,
                item_supplierEntity.email,
                item_supplierEntity.address,
                item_supplierEntity.contact_person_name,
                item_supplierEntity.contact_person_phone,
                item_supplierEntity.contact_person_email,
                item_supplierEntity.description,
                id
            ]);
            await this.dynamicConnection.query(`update item_supplier SET item_supplier =?, phone =?, email =?, address =?, contact_person_name =?, contact_person_phone =?, contact_person_email =?, description =?  where hospital_item_supplier_id = ? and Hospital_id = ?`, [
                item_supplierEntity.item_supplier,
                item_supplierEntity.phone,
                item_supplierEntity.email,
                item_supplierEntity.address,
                item_supplierEntity.contact_person_name,
                item_supplierEntity.contact_person_phone,
                item_supplierEntity.contact_person_email,
                item_supplierEntity.description,
                id,
                item_supplierEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_SUPPLIER_UPDATE,
                        "updated_values": await this.connection.query('SELECT * FROM item_supplier WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM item_supplier WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM item_supplier WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from item_supplier where hospital_item_supplier_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from item_supplier where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [{
                "status": process.env.SUCCESS_STATUS_V2,
                "message": process.env.DELETED
            }
        ];
    }
    async setupInventoryItemSupplier(search) {
        let query = ` SELECT * FROM item_supplier `;
        let values = [];
        if (search) {
            query += ` WHERE ( item_supplier.item_supplier LIKE ? OR item_supplier.phone LIKE ? OR item_supplier.email LIKE ? OR item_supplier.address LIKE ? OR item_supplier.contact_person_name LIKE ? OR item_supplier.contact_person_email LIKE ? OR item_supplier.contact_person_phone LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupInventoryItemSupplierSearch = await this.connection.query(final, values);
        return setupInventoryItemSupplierSearch;
    }
    async findInventoryItemSupplierSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM item_supplier `;
            let countQuery = `
      SELECT COUNT(item_supplier.id) AS total FROM item_supplier `;
            if (search) {
                const condition = `
      WHERE ( item_supplier.item_supplier LIKE ? OR item_supplier.phone LIKE ? OR item_supplier.email LIKE ? OR item_supplier.address LIKE ? OR item_supplier.contact_person_name LIKE ? OR item_supplier.contact_person_email LIKE ? OR item_supplier.contact_person_phone LIKE ? ) `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern, pattern, pattern, pattern, pattern, pattern);
            }
            baseQuery += ` ORDER BY item_supplier.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const ItemSupplierSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ItemSupplierSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupInventoryItemSupplierService = SetupInventoryItemSupplierService;
exports.SetupInventoryItemSupplierService = SetupInventoryItemSupplierService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupInventoryItemSupplierService);
//# sourceMappingURL=setup-inventory-item_supplier.service.js.map