"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupInventoryItemStoreService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let SetupInventoryItemStoreService = class SetupInventoryItemStoreService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(item_storeEntity) {
        try {
            const result = await this.connection.query('INSERT INTO item_store (item_store,code,description) VALUES (?,?,?)', [item_storeEntity.item_store,
                item_storeEntity.code,
                item_storeEntity.description,
            ]);
            await this.dynamicConnection.query(`INSERT INTO item_store (item_store,code,description,Hospital_id,hospital_item_store_id) VALUES (?,?,?,?,?)`, [
                item_storeEntity.item_store,
                item_storeEntity.code,
                item_storeEntity.description,
                item_storeEntity.Hospital_id,
                result.insertId
            ]);
            return [{
                    "data ": {
                        "id  ": result.insertId,
                        "status": process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_STORE,
                        "inserted_data": await this.connection.query('SELECT * FROM item_store WHERE id = ?', [result.insertId])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const item_store = await this.connection.query('SELECT * FROM item_store');
            return item_store;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM item_store WHERE id = ?`, [
            id
        ]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const item_store = await this.connection.query('SELECT * FROM item_store WHERE id = ?', [id]);
            if (item_store.length === 1) {
                return item_store;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, item_storeEntity) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM item_store WHERE id = ?`, [
            id
        ]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('UPDATE item_store SET item_store =?, code =?, description =? WHERE id = ?', [item_storeEntity.item_store,
                item_storeEntity.code,
                item_storeEntity.description,
                id
            ]);
            await this.dynamicConnection.query('update item_store SET item_store =?, code =?, description =? where hospital_item_store_id = ? and Hospital_id= ?', [
                item_storeEntity.item_store,
                item_storeEntity.code,
                item_storeEntity.description,
                id,
                item_storeEntity.Hospital_id
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.ITEM_STORE_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM item_store WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM item_store WHERE id = ?`, [
            id
        ]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query('DELETE FROM item_store WHERE id = ?', [id]);
            const [admin] = await this.dynamicConnection.query(`select id from item_store where hospital_item_store_id = ?`, [id]);
            await this.dynamicConnection.query(`delete from item_store where id = ? and Hospital_id = ?`, [admin.id, Hospital_id]);
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return [{
                "status": process.env.SUCCESS_STATUS_V2,
                "message": process.env.DELETED
            }
        ];
    }
    async setupInventoryItemStore(search) {
        let query = ` SELECT * FROM item_store `;
        let values = [];
        if (search) {
            query += ` WHERE ( item_store.item_store LIKE ? OR item_store.code LIKE ? )  `;
            values.push('%' + search + '%');
            values.push('%' + search + '%');
        }
        let final = query;
        const setupInventoryItemStoreSearch = await this.connection.query(final, values);
        return setupInventoryItemStoreSearch;
    }
    async findInventoryItemStoreSearch(search, limit, page) {
        const offset = limit * (page - 1);
        let values = [];
        try {
            let baseQuery = `
      SELECT * FROM item_store `;
            let countQuery = `
      SELECT COUNT(item_store.id) AS total FROM item_store `;
            if (search) {
                const condition = `
      WHERE item_store.item_store LIKE ? OR item_store.code LIKE ? `;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                values.push(pattern, pattern);
            }
            baseQuery += ` ORDER BY item_store.id DESC LIMIT ? OFFSET ? `;
            const paginatedValues = [...values, Number(limit), Number(offset)];
            const ItemStoreSearch = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ItemStoreSearch,
                total: countResult.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.SetupInventoryItemStoreService = SetupInventoryItemStoreService;
exports.SetupInventoryItemStoreService = SetupInventoryItemStoreService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], SetupInventoryItemStoreService);
//# sourceMappingURL=setup-inventory-item_store.service.js.map