import { DataSource } from "typeorm";
import { SetupInventoryItemStore } from "./entities/setup-inventory-item_store.entity";
import { CountDto } from "./dto/setup-inventory-item_store.dto";
export declare class SetupInventoryItemStoreService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(item_storeEntity: SetupInventoryItemStore): Promise<{
        [key: string]: any;
    }[]>;
    findAll(): Promise<SetupInventoryItemStore[]>;
    findOne(id: string): Promise<SetupInventoryItemStore | null>;
    update(id: string, item_storeEntity: SetupInventoryItemStore): Promise<{
        [key: string]: any;
    }[]>;
    remove(id: string, Hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    setupInventoryItemStore(search: string): Promise<SetupInventoryItemStore[]>;
    findInventoryItemStoreSearch(search: string, limit: number, page: number): Promise<CountDto>;
}
